﻿---
title: Persistence via Hidden Run Key Detected
description: Identifies a persistence mechanism that utilizes the NtSetValueKey native API to create a hidden (null terminated) registry key. An adversary may use...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_hidden_run_key_valuename
products:
  - Elastic Security
---

# Persistence via Hidden Run Key Detected
Identifies a persistence mechanism that utilizes the NtSetValueKey native API to create a hidden (null terminated)
registry key. An adversary may use this method to hide from system utilities such as the Registry Editor (regedit).
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- winlogbeat-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/outflanknl/SharpHide](https://github.com/outflanknl/SharpHide)](https://github.com/outflanknl/SharpHide)
- [[https://github.com/ewhitehats/InvisiblePersistence/blob/master/InvisibleRegValues_Whitepaper.pdf](https://github.com/ewhitehats/InvisiblePersistence/blob/master/InvisibleRegValues_Whitepaper.pdf)](https://github.com/ewhitehats/InvisiblePersistence/blob/master/InvisibleRegValues_Whitepaper.pdf)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Tactic: Execution
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint

**Version**: 213
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Persistence via Hidden Run Key Detected

The Windows Registry is a critical system database that stores configuration settings. Adversaries exploit it for persistence by creating hidden registry keys using native APIs, making them invisible to standard tools like regedit. The detection rule identifies changes in specific registry paths associated with startup programs, flagging null-terminated keys that suggest stealthy persistence tactics.

### Possible investigation steps

- Review the specific registry path where the change was detected to determine if it matches any of the paths listed in the query, such as "HKEY_USERS\*\Software\Microsoft\Windows\CurrentVersion\Run\" or "HKLM\Software\Microsoft\Windows\CurrentVersion\Run\".
- Check the timestamp of the registry change event to correlate it with other system activities or user actions that occurred around the same time.
- Investigate the process that made the registry change by examining process creation logs or using tools like Sysmon to identify the responsible process and its parent process.
- Analyze the content of the registry key value that was modified or created to determine if it points to a legitimate application or a potentially malicious executable.
- Cross-reference the detected registry change with known threat intelligence sources to identify if the key or value is associated with known malware or adversary techniques.
- Assess the affected system for additional indicators of compromise, such as unusual network connections, file modifications, or other persistence mechanisms.


### False positive analysis

- Legitimate software installations or updates may create registry keys in the specified paths, leading to false positives. Users can monitor the installation process and temporarily disable the rule during known software updates to prevent unnecessary alerts.
- System administrators may intentionally configure startup programs for maintenance or monitoring purposes. Document these configurations and create exceptions in the detection rule to avoid flagging them as threats.
- Some security software may use similar techniques to ensure their components start with the system. Verify the legitimacy of such software and whitelist their registry changes to prevent false alarms.
- Custom scripts or automation tools used within an organization might modify registry keys for operational reasons. Identify these scripts and exclude their activities from the detection rule to reduce false positives.
- Regularly review and update the list of known safe applications and processes that interact with the registry paths in question, ensuring that the detection rule remains relevant and accurate.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Use a trusted tool to manually inspect and remove the hidden registry keys identified in the alert from the specified registry paths to eliminate the persistence mechanism.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious files or processes associated with the threat.
- Review recent user activity and system logs to identify any unauthorized access or changes made by the adversary, and reset credentials for any compromised accounts.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are affected.
- Implement enhanced monitoring on the affected system and similar endpoints to detect any recurrence of the threat, focusing on registry changes and process execution.
- Update and reinforce endpoint security configurations to prevent similar persistence techniques, such as enabling registry auditing and restricting access to critical registry paths.


## Rule Query

```eql
/* Registry Path ends with backslash */
registry where host.os.type == "windows" and event.type == "change" and length(registry.data.strings) > 0 and
  registry.path : "*\\Run\\" and
  registry.path : (
    "*\\Software\\Microsoft\\Windows\\CurrentVersion\\Run\\",
    "*\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Run\\",
    "*\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run\\"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Registry Run Keys / Startup Folder
- Id: T1547.001
- Reference URL: [[https://attack.mitre.org/techniques/T1547/001/](https://attack.mitre.org/techniques/T1547/001/)](https://attack.mitre.org/techniques/T1547/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Native API
- Id: T1106
- Reference URL: [[https://attack.mitre.org/techniques/T1106/](https://attack.mitre.org/techniques/T1106/)](https://attack.mitre.org/techniques/T1106/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)