﻿---
title: Potential Persistence via Time Provider Modification
description: Identifies modification of the Time Provider. Adversaries may establish persistence by registering and enabling a malicious DLL as a time provider. Windows...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_time_provider_mod
products:
  - Elastic Security
---

# Potential Persistence via Time Provider Modification
Identifies modification of the Time Provider. Adversaries may establish persistence by registering and enabling a
malicious DLL as a time provider. Windows uses the time provider architecture to obtain accurate time stamps from other
network devices or clients in the network. Time providers are implemented in the form of a DLL file which resides in the
System32 folder. The service W32Time initiates during the startup of Windows and loads w32time.dll.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- endgame-*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://pentestlab.blog/2019/10/22/persistence-time-providers/](https://pentestlab.blog/2019/10/22/persistence-time-providers/)](https://pentestlab.blog/2019/10/22/persistence-time-providers/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 315
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Persistence via Time Provider Modification

The Time Provider architecture in Windows is responsible for obtaining accurate timestamps from network devices or clients. It is implemented as a DLL file in the System32 folder and is initiated by the W32Time service during Windows startup. Adversaries may exploit this by registering and enabling a malicious DLL as a time provider to establish persistence.
This rule identifies changes in the registry paths associated with Time Providers, specifically targeting the addition of new DLL files.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Examine whether the DLL is signed.
- Retrieve the DLL and determine if it is malicious:
  - Analyze the file using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and Remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Restore Time Provider settings to the desired state.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  registry.path: "*\\SYSTEM\\*ControlSet*\\Services\\W32Time\\TimeProviders\\*" and
  registry.data.strings:"*.dll" and
  not
  (
    process.executable : ("?:\\Windows\\System32\\msiexec.exe", "\\Device\\HarddiskVolume*\\Windows\\System32\\msiexec.exe") and
    registry.data.strings : "?:\\Program Files\\VMware\\VMware Tools\\vmwTimeProvider\\vmwTimeProvider.dll"
  ) and
  not registry.data.strings : "C:\\Windows\\SYSTEM32\\w32time.DLL"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Time Providers
- Id: T1547.003
- Reference URL: [[https://attack.mitre.org/techniques/T1547/003/](https://attack.mitre.org/techniques/T1547/003/)](https://attack.mitre.org/techniques/T1547/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Time Providers
- Id: T1547.003
- Reference URL: [[https://attack.mitre.org/techniques/T1547/003/](https://attack.mitre.org/techniques/T1547/003/)](https://attack.mitre.org/techniques/T1547/003/)