﻿---
title: Component Object Model Hijacking
description: Identifies Component Object Model (COM) hijacking via registry modification. Adversaries may establish persistence by executing malicious content triggered...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_com_hijack_registry
products:
  - Elastic Security
---

# Component Object Model Hijacking
Identifies Component Object Model (COM) hijacking via registry modification. Adversaries may establish persistence by
executing malicious content triggered by hijacked references to COM objects.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://bohops.com/2018/08/18/abusing-the-com-registry-structure-part-2-loading-techniques-for-evasion-and-persistence/](https://bohops.com/2018/08/18/abusing-the-com-registry-structure-part-2-loading-techniques-for-evasion-and-persistence/)](https://bohops.com/2018/08/18/abusing-the-com-registry-structure-part-2-loading-techniques-for-evasion-and-persistence/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Tactic: Privilege Escalation
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 118
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Component Object Model Hijacking

Adversaries can insert malicious code that can be executed in place of legitimate software through hijacking the COM references and relationships as a means of persistence.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Assess whether this behavior is prevalent in the environment by looking for similar occurrences across hosts.
- Retrieve the file referenced in the registry and determine if it is malicious:
  - Use a private sandboxed malware analysis system to perform analysis.
  - Observe and collect information about the following activities:
  - Attempts to contact external domains and addresses.
- File and registry access, modification, and creation activities.
- Service creation and launch activities.
- Scheduled task creation.
- Use the PowerShell Get-FileHash cmdlet to get the files' SHA-256 hash values.
  - Search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.


### False positive analysis

- Some Microsoft executables will reference the LocalServer32 registry key value for the location of external COM objects.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  /* not necessary but good for filtering privileged installations */
  user.domain != "NT AUTHORITY" and process.executable != null and 
  (
    (
      registry.path : "HK*\\InprocServer32\\" and
      registry.data.strings: ("scrobj.dll", "?:\\*\\scrobj.dll") and
      not registry.path : "*\\{06290BD*-48AA-11D2-8432-006008C3FBFC}\\*"
    ) or

    (
      registry.path : "HKLM\\*\\InProcServer32\\*" and
        registry.data.strings : ("*\\Users\\*", "*\\ProgramData\\*")
    ) or

    /* in general COM Registry changes on Users Hive is less noisy and worth alerting */
    (
      registry.path : (
        "HKEY_USERS\\*\\InprocServer32\\",
        "HKEY_USERS\\*\\LocalServer32\\",
        "HKEY_USERS\\*\\DelegateExecute",
        "HKEY_USERS\\*\\TreatAs\\",
        "HKEY_USERS\\*\\ScriptletURL*", 
        "HKEY_USERS\\*\\TypeLib*\\Win*"
      ) and
      not registry.data.strings : (
            /* COM related to Windows Spotlight feature */
            "{4813071a-41ad-44a2-9835-886d2f63ca30}",

            /* AppX/MSIX DelegateExecute handlers: execute, protocol, file */
            "{A56A841F-E974-45C1-8001-7E3F8A085917}",
            "{4ED3A719-CEA8-4BD9-910D-E252F997AFC2}",
            "{BFEC0C93-0B7D-4F2C-B09C-AFFFC4BDAE78}"
      )
    )
  ) and 
  
  not (
    process.code_signature.trusted == true and
    process.code_signature.subject_name in (
        "Island Technology Inc.", "Google LLC", "Grammarly, Inc.", "Dropbox, Inc", "REFINITIV US LLC", "HP Inc.", "Adobe Inc.",
        "Citrix Systems, Inc.", "Veeam Software Group GmbH", "Zhuhai Kingsoft Office Software Co., Ltd.", "Oracle America, Inc.",
        "Brave Software, Inc.", "DeepL SE", "Opera Norway AS"
    )
  ) and 

  /* excludes Microsoft signed noisy processes */
  not
  (
    process.name : (
      "OneDrive.exe", "OneDriveSetup.exe", "FileSyncConfig.exe", "Teams.exe", "MicrosoftEdgeUpdate.exe", "msrdcw.exe",
      "MicrosoftEdgeUpdateComRegisterShell64.exe", "setup.exe"
    ) and
    process.code_signature.trusted == true and process.code_signature.subject_name in ("Microsoft Windows", "Microsoft Corporation")
  ) and
  
  not process.executable : (
        "?:\\$WINDOWS.~BT\\Sources\\SetupHost.exe",
        "?:\\Program Files (x86)\\*.exe",
        "?:\\Program Files\\*.exe",
        "?:\\ProgramData\\4Team\\4Team-Updater\\4Team-Updater-Helper.exe",
        "?:\\ProgramData\\Microsoft\\Windows Defender\\Platform\\*\\MsMpEng.exe",
        "?:\\Users\\*\\AppData\\Local\\Wondershare\\Wondershare NativePush\\WsToastNotification.exe",
        "?:\\Windows\\System32\\DriverStore\\FileRepository\\*.exe",
        "?:\\Windows\\System32\\msiexec.exe",
        "?:\\Windows\\System32\\svchost.exe",
        "?:\\Windows\\SysWOW64\\regsvr32.exe",
        "?:\\Windows\\System32\\regsvr32.exe",
        "\\Device\\Mup\\*\\Kufer\\KuferSQL\\BasysSQL.exe"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: Component Object Model Hijacking
- Id: T1546.015
- Reference URL: [[https://attack.mitre.org/techniques/T1546/015/](https://attack.mitre.org/techniques/T1546/015/)](https://attack.mitre.org/techniques/T1546/015/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: Component Object Model Hijacking
- Id: T1546.015
- Reference URL: [[https://attack.mitre.org/techniques/T1546/015/](https://attack.mitre.org/techniques/T1546/015/)](https://attack.mitre.org/techniques/T1546/015/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)