﻿---
title: AdminSDHolder SDProp Exclusion Added
description: Identifies a modification on the dsHeuristics attribute on the bit that holds the configuration of groups excluded from the SDProp process. The SDProp...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_sdprop_exclusion_dsheuristics
products:
  - Elastic Security
---

# AdminSDHolder SDProp Exclusion Added
Identifies a modification on the dsHeuristics attribute on the bit that holds the configuration of groups excluded from
the SDProp process. The SDProp compares the permissions on protected objects with those defined on the AdminSDHolder
object. If the permissions on any of the protected accounts and groups do not match, the permissions on the protected
accounts and groups are reset to match those of the domain's AdminSDHolder object, meaning that groups excluded will
remain unchanged. Attackers can abuse this misconfiguration to maintain long-term access to privileged accounts in these
groups.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.cert.ssi.gouv.fr/uploads/guide-ad.html#dsheuristics_bad](https://www.cert.ssi.gouv.fr/uploads/guide-ad.html#dsheuristics_bad)](https://www.cert.ssi.gouv.fr/uploads/guide-ad.html#dsheuristics_bad)
- [[https://petri.com/active-directory-security-understanding-adminsdholder-object](https://petri.com/active-directory-security-understanding-adminsdholder-object)](https://petri.com/active-directory-security-understanding-adminsdholder-object)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Active Directory
- Resources: Investigation Guide
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Audit Directory Service Changes' logging policy must be configured for (Success).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
DS Access >
Audit Directory Service Changes (Success)
```


## Investigation guide


## Triage and analysis


### Investigating AdminSDHolder SDProp Exclusion Added

The SDProp process compares the permissions on protected objects with those defined on the AdminSDHolder object. If the permissions on any of the protected accounts and groups do not match, it resets the permissions on the protected accounts and groups to match those defined in the domain AdminSDHolder object.
The dSHeuristics is a Unicode string attribute, in which each character in the string represents a heuristic that is used to determine the behavior of Active Directory.
Administrators can use the dSHeuristics attribute to exclude privilege groups from the SDProp process by setting the 16th bit (dwAdminSDExMask) of the string to a certain value, which represents the group(s):
- For example, to exclude the Account Operators group, an administrator would modify the string, so the 16th character is set to 1 (i.e., 0000000001000001).

The usage of this exclusion can leave the accounts unprotected and facilitate the misconfiguration of privileges for the excluded groups, enabling attackers to add accounts to these groups to maintain long-term persistence with high privileges.
This rule matches changes of the dsHeuristics object where the 16th bit is set to a value other than zero.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account and system owners and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Check the value assigned to the 16th bit of the string on the `winlog.event_data.AttributeValue` field:
  - Account Operators eq 1
- Server Operators eq 2
- Print Operators eq 4
- Backup Operators eq 8
  The field value can range from 0 to f (15). If more than one group is specified, the values will be summed together; for example, Backup Operators and Print Operators will set the `c` value on the bit.


### False positive analysis

- While this modification can be done legitimately, it is not a best practice. Any potential benign true positive (B-TP) should be mapped and reviewed by the security team for alternatives as this weakens the security of the privileged group.


### Response and remediation

- The change can be reverted by setting the dwAdminSDExMask (16th bit) to 0 in dSHeuristics.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
any where host.os.type == "windows" and event.code == "5136" and
  winlog.event_data.AttributeLDAPDisplayName : "dSHeuristics" and
  length(winlog.event_data.AttributeValue) > 15 and
  winlog.event_data.AttributeValue regex~ "[0-9]{15}([1-9a-f]).*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Domain Accounts
- Id: T1078.002
- Reference URL: [[https://attack.mitre.org/techniques/T1078/002/](https://attack.mitre.org/techniques/T1078/002/)](https://attack.mitre.org/techniques/T1078/002/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)