﻿---
title: Unusual Scheduled Task Update
description: Identifies first-time modifications to scheduled tasks by user accounts, excluding system activity and machine accounts. Rule type: new_terms Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_scheduled_task_updated
products:
  - Elastic Security
---

# Unusual Scheduled Task Update
Identifies first-time modifications to scheduled tasks by user accounts, excluding system activity and machine accounts.
**Rule type**: new_terms
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4698](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4698)](https://docs.microsoft.com/en-us/windows/security/threat-protection/auditing/event-4698)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 117
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Scheduled Task Update

Scheduled tasks in Windows environments automate routine tasks, but adversaries can exploit them for persistence by modifying tasks to execute malicious code. The detection rule identifies first-time task modifications by non-system users, flagging potential unauthorized changes. By excluding known system accounts, it focuses on suspicious user activity, aiding in early threat detection.

### Possible investigation steps

- Review the event logs for event code 4702 to identify the specific scheduled task that was modified and the user account responsible for the change.
- Investigate the user account involved in the modification to determine if it is a legitimate user or potentially compromised. Check for any recent unusual activity associated with this account.
- Examine the details of the modified scheduled task, including the command or script it is set to execute, to assess if it is potentially malicious or unauthorized.
- Cross-reference the scheduled task's modification time with other security events or logs to identify any correlated suspicious activities or anomalies.
- Check the history of the scheduled task to determine if this is the first modification or if there have been previous changes that might indicate a pattern of unauthorized access.


### False positive analysis

- Scheduled task modifications by IT administrators performing routine maintenance can trigger alerts. To manage this, create exceptions for known administrator accounts that regularly update tasks.
- Software updates or installations by trusted applications may modify scheduled tasks. Identify these applications and exclude their associated user accounts or processes from the rule.
- Automated scripts or management tools that modify tasks as part of their normal operation can be mistaken for suspicious activity. Document these tools and exclude their activity from detection.
- Temporary user accounts used for specific projects or tasks might modify scheduled tasks. If these accounts are verified and trusted, consider excluding them from the rule during their active period.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized scheduled task modifications or potential lateral movement by the adversary.
- Terminate any suspicious processes associated with the modified scheduled task to halt any ongoing malicious activity.
- Review the modified scheduled task details, including the command or script being executed, and remove or disable any malicious components identified.
- Reset the credentials of the user account involved in the modification to prevent further unauthorized access, and investigate for any signs of credential compromise.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malware or persistence mechanisms.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if the threat has spread to other systems.
- Implement additional monitoring and alerting for scheduled task modifications across the environment to enhance detection of similar threats in the future.


## Rule Query

```kuery
event.category: "iam" and host.os.type:"windows" and event.code: "4702" and
  not winlog.event_data.SubjectUserSid : ("S-1-5-18" or "S-1-5-19" or "S-1-5-20") and
  not user.name : *$
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Scheduled Task/Job
- Id: T1053
- Reference URL: [[https://attack.mitre.org/techniques/T1053/](https://attack.mitre.org/techniques/T1053/)](https://attack.mitre.org/techniques/T1053/)
- Sub Technique:
  - Name: Scheduled Task
- Id: T1053.005
- Reference URL: [[https://attack.mitre.org/techniques/T1053/005/](https://attack.mitre.org/techniques/T1053/005/)](https://attack.mitre.org/techniques/T1053/005/)