﻿---
title: Startup or Run Key Registry Modification
description: Identifies run key or startup key registry modifications. In order to survive reboots and other system interrupts, attackers will modify run keys within...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_run_key_and_startup_broad
products:
  - Elastic Security
---

# Startup or Run Key Registry Modification
Identifies run key or startup key registry modifications. In order to survive reboots and other system interrupts,
attackers will modify run keys within the registry or leverage startup folder items as a form of persistence.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/elastic-security-uncovers-blister-malware-campaign](https://www.elastic.co/security-labs/elastic-security-uncovers-blister-malware-campaign)](https://www.elastic.co/security-labs/elastic-security-uncovers-blister-malware-campaign)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend

**Version**: 118
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Startup or Run Key Registry Modification

Adversaries may achieve persistence by referencing a program with a registry run key. Adding an entry to the run keys in the registry will cause the program referenced to be executed when a user logs in. These programs will executed under the context of the user and will have the account's permissions. This rule looks for this behavior by monitoring a range of registry run keys.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Validate if the activity is not related to planned patches, updates, network administrator activity, or legitimate software installations.
- Assess whether this behavior is prevalent in the environment by looking for similar occurrences across hosts.
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- There is a high possibility of benign legitimate programs being added to registry run keys. This activity could be based on new software installations, patches, or any kind of network administrator related activity. Before undertaking further investigation, verify that this activity is not benign.


### Related rules

- Suspicious Startup Shell Folder Modification - c8b150f0-0164-475b-a75e-74b47800a9ff
- Persistent Scripts in the Startup Directory - f7c4dc5a-a58d-491d-9f14-9b66507121c0
- Startup Folder Persistence via Unsigned Process - 2fba96c0-ade5-4bce-b92f-a5df2509da3f
- Startup Persistence by a Suspicious Process - 440e2db4-bc7f-4c96-a068-65b78da59bde


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and 
 registry.data.strings != null and registry.hive : ("HKEY_USERS", "HKLM") and
 registry.path : (
     /* Machine Hive */
     "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Run\\*",
     "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce\\*",
     "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx\\*",
     "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run\\*",
     "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon\\Shell\\*",
     /* Users Hive */
     "HKEY_USERS\\*\\Software\\Microsoft\\Windows\\CurrentVersion\\Run\\*",
     "HKEY_USERS\\*\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce\\*",
     "HKEY_USERS\\*\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx\\*",
     "HKEY_USERS\\*\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run\\*",
     "HKEY_USERS\\*\\Software\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon\\Shell\\*"
     ) and
  /* add common legitimate changes without being too restrictive as this is one of the most abused AESPs */
  not registry.data.strings : "ctfmon.exe /n" and
  not (registry.value : "Application Restart #*" and process.name : "csrss.exe") and
  not user.id : ("S-1-5-18", "S-1-5-19", "S-1-5-20") and
  not registry.data.strings : ("*:\\Program Files\\*",
                               "*:\\Program Files (x86)\\*",
                               "*:\\Users\\*\\AppData\\Local\\*",
                               "* --processStart *",
                               "* --process-start-args *",
                               "ms-teamsupdate.exe -UninstallT20",
                               " ",
                               "grpconv -o", "* /burn.runonce*", "* /startup",
                               "?:\\WINDOWS\\SysWOW64\\Macromed\\Flash\\FlashUtil32_*_Plugin.exe -update plugin") and
  not process.executable : ("?:\\Windows\\System32\\msiexec.exe",
                            "?:\\Windows\\SysWOW64\\msiexec.exe",
                            "D:\\*",
                            "\\Device\\Mup*",
                            "C:\\Windows\\SysWOW64\\reg.exe",
                            "C:\\Windows\\System32\\changepk.exe",
                            "C:\\Windows\\System32\\netsh.exe",
                            "C:\\$WINDOWS.~BT\\Sources\\SetupPlatform.exe",
                            "C:\\$WINDOWS.~BT\\Sources\\SetupHost.exe",
                            "C:\\Program Files\\Cisco Spark\\CiscoCollabHost.exe",
                            "C:\\Sistemas\\Programas MP\\CCleaner\\CCleaner64.exe",
                            "C:\\Program Files (x86)\\FastTrack Software\\Admin By Request\\AdminByRequest.exe",
                            "C:\\Program Files (x86)\\Exclaimer Ltd\\Cloud Signature Update Agent\\Exclaimer.CloudSignatureAgent.exe",
                            "C:\\ProgramData\\Lenovo\\Vantage\\AddinData\\LenovoBatteryGaugeAddin\\x64\\QSHelper.exe",
                            "C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\*\\Installer\\setup.exe",
                            "C:\\ProgramData\\bomgar-scc-*\\bomgar-scc.exe",
                            "C:\\Windows\\SysWOW64\\Macromed\\Flash\\FlashUtil*_pepper.exe",
                            "C:\\Windows\\System32\\spool\\drivers\\x64\\3\\*.EXE",
                            "C:\\Program Files (x86)\\Common Files\\Adobe\\ARM\\*\\AdobeARM.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Registry Run Keys / Startup Folder
- Id: T1547.001
- Reference URL: [[https://attack.mitre.org/techniques/T1547/001/](https://attack.mitre.org/techniques/T1547/001/)](https://attack.mitre.org/techniques/T1547/001/)