﻿---
title: Persistence via a Windows Installer
description: Identifies when the Windows installer process msiexec.exe creates a new persistence entry via scheduled tasks or startup. Rule type: eql Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_msi_installer_task_startup
products:
  - Elastic Security
---

# Persistence via a Windows Installer
Identifies when the Windows installer process msiexec.exe creates a new persistence entry via scheduled tasks or startup.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Persistence via a Windows Installer

Windows Installer, through msiexec.exe, facilitates software installation and configuration. Adversaries exploit this by creating persistence mechanisms, such as scheduled tasks or startup entries, to maintain access. The detection rule identifies suspicious activity by monitoring msiexec.exe for file creation in startup directories or registry modifications linked to auto-run keys, signaling potential persistence tactics.

### Possible investigation steps

- Review the alert details to identify the specific file path or registry path involved in the suspicious activity, focusing on the paths specified in the query such as "?:\Windows\System32\Tasks\*" or "H*\Software\Microsoft\Windows\CurrentVersion\Run\*".
- Check the creation or modification timestamps of the files or registry entries to determine when the suspicious activity occurred and correlate it with other events or logs around the same time.
- Investigate the parent process of msiexec.exe to understand how it was executed and whether it was initiated by a legitimate user action or another suspicious process.
- Examine the contents of the created or modified files or registry entries to identify any scripts, executables, or commands that may indicate malicious intent.
- Look for any associated network activity or connections initiated by msiexec.exe or related processes to identify potential command and control communication.
- Cross-reference the involved file or registry paths with known indicators of compromise or threat intelligence sources to assess the risk level and potential threat actor involvement.
- If applicable, isolate the affected system and perform a deeper forensic analysis to uncover any additional persistence mechanisms or lateral movement within the network.


### False positive analysis

- Legitimate software installations or updates may trigger the rule when msiexec.exe creates scheduled tasks or startup entries. Users can create exceptions for known software vendors or specific installation paths to reduce noise.
- System administrators might use msiexec.exe for deploying software across the network, which can appear as suspicious activity. To handle this, exclude specific administrative accounts or IP ranges from the rule.
- Some enterprise management tools may utilize msiexec.exe for legitimate configuration changes, including registry modifications. Identify and exclude these tools by their process names or associated registry paths.
- Automated scripts or deployment tools that rely on msiexec.exe for software management can generate false positives. Consider excluding these scripts or tools by their execution context or associated file paths.
- Regularly review and update the exclusion list to ensure it aligns with the current software deployment and management practices within the organization.


### Response and remediation

- Isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate the msiexec.exe process if it is confirmed to be involved in creating unauthorized persistence mechanisms.
- Remove any scheduled tasks or startup entries created by msiexec.exe that are identified as malicious or unauthorized.
- Restore any modified registry keys to their original state if they were altered to establish persistence.
- Conduct a thorough scan of the system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious files or processes.
- Review and update security policies to restrict the use of msiexec.exe for non-administrative users, reducing the risk of exploitation.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
any where host.os.type == "windows" and
  (process.name : "msiexec.exe" or Effective_process.name : "msiexec.exe") and
  (
    (
      event.category == "file" and event.action == "creation" and
      file.path : (
        "?:\\Windows\\System32\\Tasks\\*",
        "?:\\programdata\\microsoft\\windows\\start menu\\programs\\startup\\*",
        "?:\\Users\\*\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\*"
      ) and
      not file.path : (
        "?:\\Windows\\System32\\Tasks\\Adobe Acrobat Update Task",
        "?:\\Windows\\System32\\Tasks\\HP\\Sure Click\\Sure Click ?.?.??.????",
        "?:\\Windows\\System32\\Tasks\\HP\\Sure Click\\Sure Click UI ?.?.??.????",
        "?:\\Windows\\System32\\Tasks\\HP\\Sure Click\\Upgrade Repair ?.?.??.????",
        "?:\\Windows\\System32\\Tasks\\IntelSURQC-Upgrade-86621605-2a0b-4128-8ffc-15514c247132",
        "?:\\Windows\\System32\\Tasks\\IntelSURQC-Upgrade-86621605-2a0b-4128-8ffc-15514c247132-Logon"
      )
    ) or
    (
      event.category == "registry" and event.action == "modification" and registry.data.strings != null and
      registry.path : (
        "H*\\Software\\Microsoft\\Windows\\CurrentVersion\\Run\\*",
        "H*\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Run\\*",
        "H*\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run\\*",
        "H*\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run\\*"
      ) and
      not registry.data.strings : (
        "C:\\Program Files (x86)\\Common Files\\Acronis\\TibMounter\\tib_mounter_monitor.exe",
        "C:\\Program Files (x86)\\Common Files\\Java\\Java Update\\jusched.exe",
        "C:\\Program Files\\Citrix\\Secure Access Client\\CtxsDPS.exe --clean-user-installs",
        "C:\\Program Files\\OpenVPN\\bin\\openvpn-gui.exe",
        "C:\\Program Files\\Veeam\\Endpoint Backup\\Veeam.EndPoint.Tray.exe -NoControlPanel -CheckNumberOfRunningAgents",
        "\"C:\\Program Files (x86)\\Cisco\\Cisco Secure Client\\UI\\csc_ui.exe\" -minimized",
        "\"C:\\Program Files (x86)\\Citrix\\ICA Client\\concentr.exe\" /startup",
        "\"C:\\Program Files (x86)\\Citrix\\ICA Client\\Receiver\\AnalyticsSrv.exe\" /Startup",
        "\"C:\\Program Files (x86)\\Citrix\\ICA Client\\redirector.exe\" /startup",
        "\"C:\\Program Files (x86)\\EPSON Software\\Download Navigator\\EPSDNMON.EXE\"",
        "\"C:\\Program Files (x86)\\Jabra\\Direct6\\jabra-direct.exe\" /minimized",
        "\"C:\\Program Files (x86)\\VMware\\VMware Workstation\\vmware-tray.exe\"",
        "\"C:\\Program Files\\ESET\\ESET Security\\ecmds.exe\" /run /hide /proxy",
        "\"C:\\Program Files\\iTunes\\iTunesHelper.exe\"",
        "\"C:\\Program Files\\KeePassXC\\KeePassXC.exe\"",
        "\"C:\\Program Files\\Palo Alto Networks\\GlobalProtect\\PanGPA.exe\"",
        "\"C:\\Program Files\\PDF24\\pdf24.exe\"",
        "\"C:\\Program Files\\VMware\\VMware Tools\\vmtoolsd.exe\" -n vmusr",
        "\"C:\\PROGRA~2\\Citrix\\DEVICE~1\\Bin64\\DTCLIE~1.EXE\"",
        "\"%ProgramFiles%\\Teams Installer\\Teams.exe\" --checkInstall --source=default"
      )
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Scheduled Task/Job
- Id: T1053
- Reference URL: [[https://attack.mitre.org/techniques/T1053/](https://attack.mitre.org/techniques/T1053/)](https://attack.mitre.org/techniques/T1053/)
- Sub Technique:
  - Name: Scheduled Task
- Id: T1053.005
- Reference URL: [[https://attack.mitre.org/techniques/T1053/005/](https://attack.mitre.org/techniques/T1053/005/)](https://attack.mitre.org/techniques/T1053/005/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Msiexec
- Id: T1218.007
- Reference URL: [[https://attack.mitre.org/techniques/T1218/007/](https://attack.mitre.org/techniques/T1218/007/)](https://attack.mitre.org/techniques/T1218/007/)