﻿---
title: Browser Extension Install
description: Identifies the install of browser extensions. Malicious browser extensions can be installed via app store downloads masquerading as legitimate extensions,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_browser_extension_install
products:
  - Elastic Security
---

# Browser Extension Install
Identifies the install of browser extensions. Malicious browser extensions can be installed via app store downloads
masquerading as legitimate extensions, social engineering, or by an adversary that has already compromised a system.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- endgame-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: SentinelOne
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Resources: Investigation Guide

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Browser Extension Install

Browser extensions enhance functionality in web browsers but can be exploited by adversaries to gain persistence or execute malicious activities. Attackers may disguise harmful extensions as legitimate or use compromised systems to install them. The detection rule identifies suspicious extension installations by monitoring file creation events in typical extension directories, filtering out known safe processes, and focusing on Windows environments.

### Possible investigation steps

- Review the file creation event details to identify the specific browser extension file (e.g., .xpi or .crx) and its path to determine if it aligns with known malicious patterns or locations.
- Check the process that initiated the file creation event, especially if it is not a known safe process like firefox.exe, to assess if it is a legitimate application or potentially malicious.
- Investigate the user account associated with the file creation event to determine if the activity is expected or if the account may have been compromised.
- Examine recent system activity and logs for any signs of social engineering attempts or unauthorized access that could have led to the installation of the extension.
- Cross-reference the extension file name and path with threat intelligence sources to identify if it is associated with known malicious browser extensions.
- If applicable, review the browser's extension management interface to verify the presence and legitimacy of the installed extension.


### False positive analysis

- Language pack installations for Firefox can trigger false positives. Exclude files named "langpack-*@firefox.mozilla.org.xpi" from detection to prevent unnecessary alerts.
- Dictionary add-ons for Firefox may also be flagged. Add exceptions for files named "*@dictionaries.addons.mozilla.org.xpi" to reduce false positives.
- Regular updates or installations of legitimate browser extensions from trusted sources can be mistaken for malicious activity. Maintain a list of trusted processes and paths to exclude from monitoring.
- User-initiated installations from official browser stores might be flagged. Educate users on safe installation practices and consider excluding known safe processes like "firefox.exe" when associated with legitimate extension paths.
- Frequent installations in enterprise environments due to software deployment tools can cause alerts. Coordinate with IT to identify and exclude these routine activities from detection.


### Response and remediation

- Isolate the affected system from the network to prevent further spread or communication with potential command and control servers.
- Terminate any suspicious processes associated with the unauthorized browser extension installation, such as unknown or unexpected instances of browser processes.
- Remove the malicious browser extension by deleting the associated files from the extension directories identified in the alert.
- Conduct a full antivirus and anti-malware scan on the affected system to identify and remove any additional threats or remnants of the malicious extension.
- Review and reset browser settings to default to ensure no residual configurations or settings are left by the malicious extension.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems are affected.
- Implement application whitelisting to prevent unauthorized browser extensions from being installed in the future, focusing on the directories and file types identified in the detection query.


## Rule Query

```eql
file where host.os.type == "windows" and event.type : "creation" and
(
  /* Firefox-Based Browsers */
  (
    file.name : "*.xpi" and
    file.path : "?:\\Users\\*\\AppData\\Roaming\\*\\Profiles\\*\\Extensions\\*.xpi" and
    not
    (
      process.name : "firefox.exe" and
      file.name : (
        "langpack-*@firefox.mozilla.org.xpi",
        "*@dictionaries.addons.mozilla.org.xpi",
        "newtab@mozilla.org.xpi",
        "uBlock0@raymondhill.net.xpi",
        /* AdBlockPlus */
        "{d10d0bf8-f5b5-c8b4-a8b2-2b9879e08c5d}.xpi",
        /* Bitwarden */
        "{446900e4-71c2-419f-a6a7-df9c091e268b}.xpi",
        "addon@darkreader.org.xpi",
        /* 1Password */
        "{d634138d-c276-4fc8-924b-40a0ea21d284}.xpi",
        "support@lastpass.com.xpi",
        /* Grammarly */
        "87677a2c52b84ad3a151a4a72f5bd3c4@jetpack.xpi",
        "sentinelone_visibility@sentinelone.com.xpi",
        "keepassxc-browser@keepassxc.org.xpi"
      )
    )
  ) or
  /* Chromium-Based Browsers */
  (
    file.name : "*.crx" and
    file.path : "?:\\Users\\*\\AppData\\Local\\*\\*\\User Data\\Webstore Downloads\\*"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Software Extensions
- Id: T1176
- Reference URL: [[https://attack.mitre.org/techniques/T1176/](https://attack.mitre.org/techniques/T1176/)](https://attack.mitre.org/techniques/T1176/)