﻿---
title: Registry Persistence via AppInit DLL
description: AppInit DLLs are dynamic-link libraries (DLLs) that are loaded into every process that creates a user interface (loads user32.dll) on Microsoft Windows...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_appinitdlls_registry
products:
  - Elastic Security
---

# Registry Persistence via AppInit DLL
AppInit DLLs are dynamic-link libraries (DLLs) that are loaded into every process that creates a user interface (loads
user32.dll) on Microsoft Windows operating systems. The AppInit DLL mechanism is used to load custom code into user-mode
processes, allowing for the customization of the user interface and the behavior of Windows-based applications.
Attackers who add those DLLs to the registry locations can execute code with elevated privileges, similar to process
injection, and provide a solid and constant persistence on the machine.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.registry-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 315
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Registry Persistence via AppInit DLL

AppInit DLLs are dynamic-link libraries (DLLs) that are loaded into every process that creates a user interface (loads `user32.dll`) on Microsoft Windows operating systems. The AppInit DLL mechanism is used to load custom code into user-mode processes, allowing for the customization of the user interface and the behavior of Windows-based applications.
Attackers who add those DLLs to the registry locations can execute code with elevated privileges, similar to process injection, and provide a solid and constant persistence on the machine.
This rule identifies modifications on the AppInit registry keys.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Review the source process and related DLL file tied to the Windows Registry entry.
  - Check whether the DLL is signed, and tied to a authorized program used on your environment.
- Assess whether this behavior is prevalent in the environment by looking for similar occurrences across hosts.
- Retrieve all DLLs under the AppInit registry keys:
  - $osquery_0
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable and the DLLs using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_1
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_2
- $osquery_3
- $osquery_4
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  registry.value : "AppInit_Dlls" and
  not process.executable : (
     "?:\\Windows\\System32\\DriverStore\\FileRepository\\*\\Display.NvContainer\\NVDisplay.Container.exe",
     "?:\\Windows\\System32\\msiexec.exe",
     "?:\\Windows\\SysWOW64\\msiexec.exe",
     "?:\\Program Files\\Commvault\\Base\\cvd.exe",
     "?:\\Program Files\\Commvault\\ContentStore*\\Base\\cvd.exe",
     "?:\\Program Files (x86)\\Commvault\\Base\\cvd.exe",
     "?:\\Program Files (x86)\\Commvault\\ContentStore*\\Base\\cvd.exe",
     "?:\\Program Files\\NVIDIA Corporation\\Display.NvContainer\\NVDisplay.Container.exe",

     /* Crowdstrike specific condition as it uses NT Object paths */
     "\\Device\\HarddiskVolume*\\Windows\\System32\\DriverStore\\FileRepository\\*\\Display.NvContainer\\NVDisplay.Container.exe",
     "\\Device\\HarddiskVolume*\\Windows\\System32\\msiexec.exe",
     "\\Device\\HarddiskVolume*\\Windows\\SysWOW64\\msiexec.exe",
     "\\Device\\HarddiskVolume*\\Program Files\\Commvault\\Base\\cvd.exe",
     "\\Device\\HarddiskVolume*\\Program Files\\Commvault\\ContentStore*\\Base\\cvd.exe",
     "\\Device\\HarddiskVolume*\\Program Files (x86)\\Commvault\\Base\\cvd.exe",
     "\\Device\\HarddiskVolume*\\Program Files (x86)\\Commvault\\ContentStore*\\Base\\cvd.exe",
     "\\Device\\HarddiskVolume*\\Program Files\\NVIDIA Corporation\\Display.NvContainer\\NVDisplay.Container.exe"
  )
  /*
    Full registry key path omitted due to data source variations:
    "HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Windows\\AppInit_Dlls"
    "HKLM\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows NT\\CurrentVersion\\Windows\\AppInit_Dlls"
  */
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: AppInit DLLs
- Id: T1546.010
- Reference URL: [[https://attack.mitre.org/techniques/T1546/010/](https://attack.mitre.org/techniques/T1546/010/)](https://attack.mitre.org/techniques/T1546/010/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)