﻿---
title: Installation of Custom Shim Databases
description: Identifies the installation of custom Application Compatibility Shim databases. This Windows functionality has been abused by attackers to stealthily...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_app_compat_shim
products:
  - Elastic Security
---

# Installation of Custom Shim Databases
Identifies the installation of custom Application Compatibility Shim databases. This Windows functionality has been
abused by attackers to stealthily gain persistence and arbitrary code execution in legitimate Windows processes.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- winlogbeat-*
- logs-windows.sysmon_operational-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- endgame-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 313
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Installation of Custom Shim Databases

Application Compatibility Shim databases are used in Windows to ensure older applications run smoothly on newer OS versions by applying compatibility fixes. However, attackers can exploit this feature to maintain persistence and execute arbitrary code by installing malicious shim databases. The detection rule identifies changes in specific registry paths associated with these databases, excluding known legitimate processes, to flag potential abuse.

### Possible investigation steps

- Review the registry path changes identified in the alert to confirm the presence of any unexpected or unauthorized .sdb files in the specified registry paths.
- Investigate the process that made the registry change by examining the process executable path and comparing it against the list of known legitimate processes excluded in the query.
- Check the historical activity of the process responsible for the change to identify any patterns or anomalies that might indicate malicious behavior.
- Analyze the context around the time of the registry change, including other system events or alerts, to identify any related suspicious activities.
- If a suspicious .sdb file is found, conduct a file analysis to determine its purpose and whether it contains any malicious code or configurations.
- Consult threat intelligence sources to see if there are any known threats or campaigns associated with the identified process or .sdb file.


### False positive analysis

- Known legitimate processes such as SAP and Kaspersky applications may trigger false positives due to their use of shim databases. These processes are already excluded in the detection rule to minimize unnecessary alerts.
- If additional legitimate applications are identified as causing false positives, users can update the exclusion list by adding the specific process executable paths to the rule.
- Regularly review and update the exclusion list to ensure it reflects the current environment and any new legitimate applications that may use shim databases.
- Monitor the frequency and context of alerts to distinguish between benign and potentially malicious activities, adjusting the rule as necessary to reduce noise.
- Engage with application owners to verify the legitimacy of processes that frequently trigger alerts, ensuring that only trusted applications are excluded.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further propagation or communication with potential command and control servers.
- Terminate any suspicious processes identified as responsible for the installation of the custom shim database, ensuring they are not legitimate processes mistakenly flagged.
- Remove the malicious shim database entries from the registry paths specified in the detection query to eliminate persistence mechanisms.
- Conduct a thorough scan of the affected system using updated antivirus and endpoint detection tools to identify and remove any additional malware or unauthorized changes.
- Review and restore any altered system configurations or files to their original state to ensure system integrity.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for the specified registry paths and associated processes to detect and respond to similar threats in the future.


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and
  registry.path : "*\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Custom\\*.sdb" and
  not process.executable : (
        "?:\\Program Files (x86)\\DesktopCentral_Agent\\*\\Setup\\NwSapSetup.exe",
        "?:\\$WINDOWS.~BT\\Sources\\SetupPlatform.exe",
        "?:\\Program Files (x86)\\SAP\\SAPsetup\\setup\\NwSapSetup.exe",
        "?:\\Program Files (x86)\\SAP\\SapSetup\\OnRebootSvc\\NWSAPSetupOnRebootInstSvc.exe",
        "?:\\Program Files (x86)\\Kaspersky Lab\\Kaspersky Security for Windows Server\\kavfs.exe",

        /* Crowdstrike specific exclusion as it uses NT Object paths */
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\DesktopCentral_Agent\\*\\Setup\\NwSapSetup.exe",
        "\\Device\\HarddiskVolume*\\$WINDOWS.~BT\\Sources\\SetupPlatform.exe",
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\SAP\\SAPsetup\\setup\\NwSapSetup.exe",
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\SAP\\SapSetup\\OnRebootSvc\\NWSAPSetupOnRebootInstSvc.exe",
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\Kaspersky Lab\\Kaspersky Security for Windows Server\\kavfs.exe"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: Application Shimming
- Id: T1546.011
- Reference URL: [[https://attack.mitre.org/techniques/T1546/011/](https://attack.mitre.org/techniques/T1546/011/)](https://attack.mitre.org/techniques/T1546/011/)