﻿---
title: Remote Execution via File Shares
description: Identifies the execution of a file that was created by the virtual system process. This may indicate lateral movement via network file shares. Rule type:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_execution_via_file_shares_sequence
products:
  - Elastic Security
---

# Remote Execution via File Shares
Identifies the execution of a file that was created by the virtual system process. This may indicate lateral movement
via network file shares.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [http://web.archive.org/web/20230329172636/[https://blog.menasec.net/2020/08/new-trick-to-detect-lateral-movement.html](https://blog.menasec.net/2020/08/new-trick-to-detect-lateral-movement.html)](http://web.archive.org/web/20230329172636/https://blog.menasec.net/2020/08/new-trick-to-detect-lateral-movement.html)
- [[https://www.elastic.co/security-labs/hunting-for-lateral-movement-using-event-query-language](https://www.elastic.co/security-labs/hunting-for-lateral-movement-using-event-query-language)](https://www.elastic.co/security-labs/hunting-for-lateral-movement-using-event-query-language)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend

**Version**: 120
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Remote Execution via File Shares

Adversaries can use network shares to host tooling to support the compromise of other hosts in the environment. These tools can include discovery utilities, credential dumpers, malware, etc.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Review adjacent login events (e.g., 4624) in the alert timeframe to identify the account used to perform this action.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- This activity can happen legitimately. Consider adding exceptions if it is expected and noisy in your environment.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Review the privileges needed to write to the network share and restrict write access as needed.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence with maxspan=1m
  [file where host.os.type == "windows" and event.type in ("creation", "change") and 
   process.pid == 4 and (file.extension : "exe" or file.Ext.header_bytes : "4d5a*")] by host.id, file.path
  [process where host.os.type == "windows" and event.type == "start" and
    not (
      (
        process.code_signature.trusted == true and
        process.code_signature.subject_name : (
              "Veeam Software Group GmbH",
              "Elasticsearch, Inc.",
              "PDQ.com Corporation",
              "CrowdStrike, Inc.",
              "Microsoft Windows Hardware Compatibility Publisher",
              "ZOHO Corporation Private Limited",
              "BeyondTrust Corporation", 
              "CyberArk Software Ltd.", 
              "Sophos Ltd"
        )
      ) or
      (
        process.executable : (
          "?:\\Windows\\ccmsetup\\ccmsetup.exe",
          "?:\\Windows\\SoftwareDistribution\\Download\\Install\\AM_Delta*.exe",
          "?:\\Windows\\CAInvokerService.exe"
        ) and process.code_signature.trusted == true
      ) or
      (
        process.executable : "G:\\SMS_*\\srvboot.exe" and 
        process.code_signature.trusted == true and process.code_signature.subject_name : "Microsoft Corporation"
      )
    )
  ] by host.id, process.executable
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)
- Sub Technique:
  - Name: SMB/Windows Admin Shares
- Id: T1021.002
- Reference URL: [[https://attack.mitre.org/techniques/T1021/002/](https://attack.mitre.org/techniques/T1021/002/)](https://attack.mitre.org/techniques/T1021/002/)