﻿---
title: Suspicious Kerberos Authentication Ticket Request
description: Correlates network connections to the standard Kerberos port by an unusual process from the source machine with a Kerberos authentication ticket request...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_credential_access_kerberos_correlation
products:
  - Elastic Security
---

# Suspicious Kerberos Authentication Ticket Request
Correlates network connections to the standard Kerberos port by an unusual process from the source machine with a Kerberos
authentication ticket request from the target domain controller.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-windows.sysmon_operational-*
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/its-a-feature/bifrost](https://github.com/its-a-feature/bifrost)](https://github.com/its-a-feature/bifrost)
- [[https://learn.microsoft.com/en-us/previous-versions/windows/it-pro/windows-10/security/threat-protection/auditing/event-4768](https://learn.microsoft.com/en-us/previous-versions/windows/it-pro/windows-10/security/threat-protection/auditing/event-4768)](https://learn.microsoft.com/en-us/previous-versions/windows/it-pro/windows-10/security/threat-protection/auditing/event-4768)

**Tags**:
- Domain: Endpoint
- Domain: Identity
- OS: Windows
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Lateral Movement
- Use Case: Active Directory Monitoring
- Data Source: Active Directory
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Suspicious Kerberos Authentication Ticket Request

Kerberos is the default authentication protocol in Active Directory, designed to provide strong authentication for client/server applications by using secret-key cryptography.
Domain-joined hosts usually perform Kerberos traffic using the `lsass.exe` process. This rule detects the occurrence of traffic on the Kerberos port (88) by processes other than `lsass.exe` to detect the unusual request and usage of Kerberos tickets.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Check if the Destination IP is related to a Domain Controller.
- Review events ID 4769 and 4768 for suspicious ticket requests.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- Active Directory audit tools.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
  - Ticket requests can be used to investigate potentially compromised accounts.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by source.port, source.ip with maxspan=3s
 [network where host.os.type == "windows" and destination.port == 88 and
  process.executable != null and process.pid != 4 and 
  not process.executable : 
              ("?:\\Windows\\system32\\lsass.exe", 
               "\\device\\harddiskvolume*\\windows\\system32\\lsass.exe", 
               "\\device\\harddiskvolume*\\windows\\system32\\svchost.exe") and
  not (process.executable : ("C:\\Windows\\System32\\svchost.exe", 
                             "C:\\Program Files\\VMware\\VMware View\\Server\\bin\\ws_TomcatService.exe", 
                             "F:\\IGEL\\RemoteManager\\*\\bin\\tomcat10.exe") and user.id in ("S-1-5-20", "S-1-5-18")) and   
  source.ip != "127.0.0.1" and destination.ip != "::1" and destination.ip != "127.0.0.1"]
 [authentication where host.os.type == "windows" and event.code in ("4768", "4769")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Pass the Ticket
- Id: T1550.003
- Reference URL: [[https://attack.mitre.org/techniques/T1550/003/](https://attack.mitre.org/techniques/T1550/003/)](https://attack.mitre.org/techniques/T1550/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal or Forge Kerberos Tickets
- Id: T1558
- Reference URL: [[https://attack.mitre.org/techniques/T1558/](https://attack.mitre.org/techniques/T1558/)](https://attack.mitre.org/techniques/T1558/)
- Sub Technique:
  - Name: Kerberoasting
- Id: T1558.003
- Reference URL: [[https://attack.mitre.org/techniques/T1558/003/](https://attack.mitre.org/techniques/T1558/003/)](https://attack.mitre.org/techniques/T1558/003/)