﻿---
title: Windows Server Update Service Spawning Suspicious Processes
description: Identifies suspicious processes being spawned by the Windows Server Update Service. This activity may indicate exploitation activity or access to an existing...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_windows_server_update_svc
products:
  - Elastic Security
---

# Windows Server Update Service Spawning Suspicious Processes
Identifies suspicious processes being spawned by the Windows Server Update Service. This activity may indicate exploitation
activity or access to an existing web shell backdoor.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- winlogbeat-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-59287](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-59287)](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-59287)
- [[https://hawktrace.com/blog/CVE-2025-59287](https://hawktrace.com/blog/CVE-2025-59287)](https://hawktrace.com/blog/CVE-2025-59287)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Windows Server Update Service Spawning Suspicious Processes


### Possible investigation steps

- Examine the child process details, focusing on the process names and original file names such as cmd.exe, powershell.exe, pwsh.exe, and powershell_ise.exe, to identify any unauthorized or unexpected command-line activity.
- Investigate the timeline of events leading up to the alert, including any preceding or subsequent processes, to understand the context and potential impact of the suspicious activity.
- Check for any associated network activity or connections initiated by the suspicious processes to identify potential data exfiltration or communication with external command and control servers.
- Review recent changes or access logs on the affected  server to identify any unauthorized access attempts or modifications that could indicate exploitation or the presence of a web shell.
- Correlate the alert with other security events or logs from data sources like Elastic Endgame, Elastic Defend, Sysmon, Microsoft Defender for Endpoint, or SentinelOne to gather additional context and corroborate findings.
- Assess the risk and impact of the detected activity, considering the severity and risk score, and determine appropriate response actions, such as isolating the affected system or conducting a deeper forensic analysis.


### False positive analysis

- This behavior is rare and should be treated with high suspicion.


### Response and remediation

- Immediately isolate the affected Server from the network to prevent further unauthorized access or lateral movement.
- Terminate any suspicious processes identified as being spawned by w3wp.exe, such as cmd.exe or powershell.exe, to halt any ongoing malicious activity.
- Conduct a thorough review of the server's application pools and web directories to identify and remove any unauthorized web shells or scripts.
- Restore the server from a known good backup taken before the suspicious activity was detected to ensure system integrity.
- Apply the latest security patches and updates to the Server to mitigate known vulnerabilities and prevent exploitation.
- Monitor network traffic and server logs for any signs of continued or attempted exploitation, focusing on unusual outbound connections or repeated access attempts.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems have been compromised.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : ("cmd.exe", "powershell.exe", "pwsh.exe", "powershell_ise.exe", "rundll32.exe", "curl.exe") and
  (
   (process.parent.name : "w3wp.exe" and process.parent.args : "WsusPool") or
   process.parent.name : "WsusService.exe"
   )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)
- Sub Technique:
  - Name: Windows Command Shell
- Id: T1059.003
- Reference URL: [[https://attack.mitre.org/techniques/T1059/003/](https://attack.mitre.org/techniques/T1059/003/)](https://attack.mitre.org/techniques/T1059/003/)