﻿---
title: Microsoft Exchange Server UM Spawning Suspicious Processes
description: Identifies suspicious processes being spawned by the Microsoft Exchange Server Unified Messaging (UM) service. This activity has been observed exploiting...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_exchange_process
products:
  - Elastic Security
---

# Microsoft Exchange Server UM Spawning Suspicious Processes
Identifies suspicious processes being spawned by the Microsoft Exchange Server Unified Messaging (UM) service. This
activity has been observed exploiting CVE-2021-26857.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.microsoft.com/security/blog/2021/03/02/hafnium-targeting-exchange-servers](https://www.microsoft.com/security/blog/2021/03/02/hafnium-targeting-exchange-servers)](https://www.microsoft.com/security/blog/2021/03/02/hafnium-targeting-exchange-servers)
- [[https://www.volexity.com/blog/2021/03/02/active-exploitation-of-microsoft-exchange-zero-day-vulnerabilities](https://www.volexity.com/blog/2021/03/02/active-exploitation-of-microsoft-exchange-zero-day-vulnerabilities)](https://www.volexity.com/blog/2021/03/02/active-exploitation-of-microsoft-exchange-zero-day-vulnerabilities)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Lateral Movement
- Data Source: Elastic Endgame
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 316
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Microsoft Exchange Server UM Spawning Suspicious Processes

Microsoft Exchange Server's Unified Messaging (UM) integrates voice messaging with email, allowing users to access voicemails via their inbox. Adversaries exploit vulnerabilities like CVE-2021-26857 to execute unauthorized processes, potentially leading to system compromise. The detection rule identifies unusual processes initiated by UM services, excluding known legitimate executables, to flag potential exploitation attempts.

### Possible investigation steps

- Review the alert details to confirm the process parent name is either "UMService.exe" or "UMWorkerProcess.exe" and verify the process executable path is not among the known legitimate paths listed in the exclusion criteria.
- Gather additional context by checking the process command line arguments and the user account under which the suspicious process was executed to identify any anomalies or unauthorized access.
- Investigate the historical activity of the host by reviewing recent logs for any other unusual or unauthorized processes, especially those related to the Microsoft Exchange Server.
- Check for any recent patches or updates applied to the Microsoft Exchange Server to ensure that vulnerabilities like CVE-2021-26857 have been addressed.
- Correlate the alert with other security tools and data sources such as Microsoft Defender for Endpoint or Sysmon to identify any related suspicious activities or indicators of compromise.
- Assess the network activity from the host to detect any potential lateral movement or data exfiltration attempts that might be associated with the suspicious process.


### False positive analysis

- Legitimate UM service updates or patches may trigger the rule. Regularly update the list of known legitimate executables to include new or updated UM service files.
- Custom scripts or monitoring tools that interact with UM services might be flagged. Identify these scripts and add their executables to the exclusion list if they are verified as safe.
- Non-standard installation paths for Exchange Server can cause false positives. Ensure that all legitimate installation paths are included in the exclusion list to prevent unnecessary alerts.
- Administrative tasks performed by IT staff using command-line tools may be misidentified. Document these tasks and consider excluding the associated executables if they are part of routine maintenance.
- Third-party integrations with Exchange Server that spawn processes could be flagged. Verify these integrations and exclude their executables if they are deemed secure and necessary for business operations.


### Response and remediation

- Isolate the affected Microsoft Exchange Server from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified as being spawned by the UM service that are not part of the known legitimate executables list.
- Apply the latest security patches and updates to the Microsoft Exchange Server to address CVE-2021-26857 and any other known vulnerabilities.
- Conduct a thorough review of the server's security logs and network traffic to identify any additional indicators of compromise or unauthorized access attempts.
- Restore the server from a known good backup taken before the suspicious activity was detected, ensuring that the backup is free from compromise.
- Implement enhanced monitoring and alerting for any future suspicious processes spawned by the UM service, using the detection rule as a baseline.
- Escalate the incident to the organization's security operations center (SOC) or incident response team for further investigation and to determine if additional systems may be affected.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.parent.name : ("UMService.exe", "UMWorkerProcess.exe") and
    not process.executable : (
          "?:\\Windows\\System32\\werfault.exe",
          "?:\\Windows\\System32\\wermgr.exe",
          "?:\\Program Files\\Microsoft\\Exchange Server\\V??\\Bin\\UMWorkerProcess.exe",
          "?:\\Program Files\\Microsoft\\Exchange Server\\Bin\\UMWorkerProcess.exe",
          "D:\\Exchange 2016\\Bin\\UMWorkerProcess.exe",
          "E:\\ExchangeServer\\Bin\\UMWorkerProcess.exe",
          "D:\\Exchange\\Bin\\UMWorkerProcess.exe",
          "D:\\Exchange Server\\Bin\\UMWorkerProcess.exe",
          "E:\\Exchange Server\\V15\\Bin\\UMWorkerProcess.exe",

          /* Crowdstrike specific exclusion as it uses NT Object paths */
          "\\Device\\HarddiskVolume*\\Windows\\System32\\werfault.exe",
          "\\Device\\HarddiskVolume*\\Windows\\System32\\wermgr.exe",
          "\\Device\\HarddiskVolume*\\Program Files\\Microsoft\\Exchange Server\\V??\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\Program Files\\Microsoft\\Exchange Server\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\Exchange 2016\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\ExchangeServer\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\Exchange\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\Exchange Server\\Bin\\UMWorkerProcess.exe",
          "\\Device\\HarddiskVolume*\\Exchange Server\\V15\\Bin\\UMWorkerProcess.exe"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Exploitation of Remote Services
- Id: T1210
- Reference URL: [[https://attack.mitre.org/techniques/T1210/](https://attack.mitre.org/techniques/T1210/)](https://attack.mitre.org/techniques/T1210/)