﻿---
title: Suspicious SolarWinds Web Help Desk Java Module Load or Child Process
description: Identifies the SolarWinds Web Help Desk Java process loading an untrusted or remote native module (DLL). This behavior is uncommon for the Web Help Desk...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_potential_webhelpdesk_exploit
products:
  - Elastic Security
---

# Suspicious SolarWinds Web Help Desk Java Module Load or Child Process
Identifies the SolarWinds Web Help Desk Java process loading an untrusted or remote native module (DLL).
This behavior is uncommon for the Web Help Desk server and may indicate successful exploitation of
deserialization vulnerabilities (CVE-2025-40536, CVE-2025-40551), which allow attackers to load malicious
SQLite extensions and achieve remote code execution.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://horizon3.ai/attack-research/cve-2025-40551-another-solarwinds-web-help-desk-deserialization-issue/](https://horizon3.ai/attack-research/cve-2025-40551-another-solarwinds-web-help-desk-deserialization-issue/)](https://horizon3.ai/attack-research/cve-2025-40551-another-solarwinds-web-help-desk-deserialization-issue/)
- [[https://github.com/rapid7/metasploit-framework/pull/20917](https://github.com/rapid7/metasploit-framework/pull/20917)](https://github.com/rapid7/metasploit-framework/pull/20917)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, validate the guidance and adapt it to your environment and operational requirements.

### Investigating Suspicious SolarWinds Web Help Desk Java Module Load or Child Process"

SolarWinds Web Help Desk is a Java-based, internet-facing application commonly deployed on Windows servers.
Recent vulnerabilities (CVE-2025-40536, CVE-2025-40551) allow unauthenticated attackers to exploit unsafe
deserialization and abuse SQLite extension loading to execute arbitrary native code within the Java process.
This rule detects suspicious native module (DLL) loads by the Web Help Desk Java process, as well as
post-exploitation child process execution, both of which are strong indicators of successful exploitation.

### Possible investigation steps

- Review the **process executable path** to confirm the activity originated from the Web Help Desk Java runtime (e.g., `WebHelpDesk\jre\bin\java.exe`).
- Examine the **loaded DLL path**:
  - Pay special attention to DLLs loaded from UNC paths (e.g., `\<IP>\share\*.dll`) or temporary directories.
- Validate whether the DLL is unsigned or has an untrusted code signature.
- Review **network telemetry** around the time of the alert for outbound SMB connections (TCP 445) originating from the Java process.
- If a child process was spawned (e.g., `cmd.exe`, `powershell.exe`, `rundll32.exe`):
  - Inspect command-line arguments for evidence of payload execution, staging, or persistence.
- Check system logs for additional indicators of compromise, including scheduled task creation, service installation, or persistence mechanisms.
- Determine the Web Help Desk version in use and confirm whether security patches addressing the relevant CVEs have been applied.


### False positive analysis

- Legitimate Web Help Desk installations typically do not load arbitrary native extensions at runtime. False positives are expected to be rare.
- Custom integrations or troubleshooting activities that involve native JDBC extensions could trigger this rule. Validate whether such behavior is expected in your environment.
- Security software or backup agents interacting with Java processes may occasionally load signed native libraries; verify the DLL origin and signature before dismissing the alert.


### Response and remediation

- Treat this alert as a **high-confidence compromise indicator** if the DLL is untrusted or loaded from a remote path.
- Isolate the affected host to prevent further lateral movement or payload staging.
- Terminate suspicious child processes and capture memory artifacts if possible for forensic analysis.
- Remove any malicious files identified on disk and review persistence mechanisms.
- Apply the latest SolarWinds Web Help Desk security updates addressing CVE-2025-40536 and CVE-2025-40551.
- Conduct a broader environment sweep to identify other potentially vulnerable or compromised Web Help Desk instances.
- Escalate the incident to the security operations or incident response team for full containment and remediation.


## Rule Query

```eql
any where host.os.type == "windows" and
(
 (event.category == "library" and
  process.executable : ("C:\\Program Files\\WebHelpDesk\\*\\java.exe", "C:\\Program Files (x86)\\WebHelpDesk\\*\\java.exe") and
  (dll.path : "\\Device\\Mup\\*" or dll.code_signature.trusted == false or ?dll.code_signature.exists == false)) or

 (event.category == "process" and process.name : ("cmd.exe", "powershell.exe", "rundll32.exe") and
  process.parent.executable : ("C:\\Program Files\\WebHelpDesk\\*\\java*.exe", "C:\\Program Files (x86)\\WebHelpDesk\\*\\java*.exe"))
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)