﻿---
title: Suspicious JetBrains TeamCity Child Process
description: Identifies suspicious processes being spawned by the JetBrain TeamCity process. This activity could be related to JetBrains remote code execution vulnerabilities...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_exploit_jetbrains_teamcity
products:
  - Elastic Security
---

# Suspicious JetBrains TeamCity Child Process
Identifies suspicious processes being spawned by the JetBrain TeamCity process. This activity could be related to
JetBrains remote code execution vulnerabilities.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.trendmicro.com/en_us/research/24/c/teamcity-vulnerability-exploits-lead-to-jasmin-ransomware.html](https://www.trendmicro.com/en_us/research/24/c/teamcity-vulnerability-exploits-lead-to-jasmin-ransomware.html)](https://www.trendmicro.com/en_us/research/24/c/teamcity-vulnerability-exploits-lead-to-jasmin-ransomware.html)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Data Source: Elastic Endgame
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Data Source: Microsoft Defender for Endpoint
- Data Source: Windows Security Event Logs
- Data Source: Sysmon
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious JetBrains TeamCity Child Process

JetBrains TeamCity is a continuous integration and deployment server used to automate software development processes. Adversaries may exploit vulnerabilities in TeamCity to execute unauthorized code, potentially spawning malicious child processes. The detection rule identifies unusual child processes initiated by TeamCity's Java executable, flagging potential exploitation attempts by monitoring for known suspicious executables, while excluding legitimate operations.

### Possible investigation steps

- Review the process tree to identify the parent and child processes associated with the suspicious activity, focusing on the parent executable paths like "?:\TeamCity\jre\bin\java.exe".
- Examine the command-line arguments of the suspicious child processes, especially those involving "cmd.exe" or "powershell.exe", to understand the actions being executed.
- Check for any recent vulnerabilities or patches related to JetBrains TeamCity that might explain the suspicious behavior.
- Investigate the user account under which the suspicious processes were executed to determine if it aligns with expected usage patterns or if it indicates potential compromise.
- Correlate the alert with other security events or logs from data sources like Sysmon or Microsoft Defender for Endpoint to identify any related malicious activity or indicators of compromise.
- Assess network activity from the host to detect any unusual outbound connections that might suggest data exfiltration or communication with a command and control server.


### False positive analysis

- Legitimate build scripts may invoke command-line utilities like cmd.exe or powershell.exe. To handle these, create exceptions for specific scripts by matching known safe arguments or paths.
- Automated tasks or maintenance scripts might use network utilities such as ping.exe or netstat.exe. Exclude these by identifying and allowing specific scheduled tasks or maintenance windows.
- System monitoring tools could trigger processes like tasklist.exe or systeminfo.exe. Whitelist these tools by verifying their source and ensuring they are part of authorized monitoring solutions.
- Development or testing environments may frequently use utilities like explorer.exe or control.exe. Establish exceptions for these environments by defining specific hostnames or IP ranges where such activity is expected.
- Custom scripts or applications might use msiexec.exe for legitimate software installations. Allow these by confirming the source and purpose of the installations, and excluding them based on known safe paths or signatures.


### Response and remediation

- Immediately isolate the affected TeamCity server from the network to prevent further unauthorized access or lateral movement.
- Terminate any suspicious child processes identified by the detection rule, such as cmd.exe or powershell.exe, to halt potential malicious activities.
- Conduct a thorough review of recent changes and deployments in TeamCity to identify any unauthorized modifications or suspicious activities.
- Apply the latest security patches and updates to TeamCity and its underlying Java runtime environment to mitigate known vulnerabilities.
- Restore the affected system from a clean backup taken before the suspicious activity was detected, ensuring no remnants of the exploit remain.
- Monitor network traffic and system logs for any signs of continued or related suspicious activity, focusing on the indicators identified in the detection rule.
- Escalate the incident to the security operations center (SOC) or relevant IT security team for further investigation and to assess the need for additional security measures.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.parent.executable :
                 ("?:\\TeamCity\\jre\\bin\\java.exe",
                  "?:\\Program Files\\TeamCity\\jre\\bin\\java.exe",
                  "?:\\Program Files (x86)\\TeamCity\\jre\\bin\\java.exe",
                  "?:\\TeamCity\\BuildAgent\\jre\\bin\\java.exe") and
  process.name : ("cmd.exe", "powershell.exe", "msiexec.exe", "certutil.exe", "bitsadmin.exe", "wmic.exe", "curl.exe", "ssh.exe",
                   "rundll32.exe", "regsvr32.exe", "mshta.exe", "certreq.exe", "net.exe", "nltest.exe", "whoami.exe", "hostname.exe",
                   "tasklist.exe", "arp.exe", "nbtstat.exe", "netstat.exe", "reg.exe", "tasklist.exe", "Microsoft.Workflow.Compiler.exe",
                   "arp.exe", "atbroker.exe", "bginfo.exe", "bitsadmin.exe", "cdb.exe", "cmstp.exe", "control.exe", "cscript.exe", "csi.exe",
                   "dnx.exe", "dsget.exe", "dsquery.exe", "forfiles.exe", "fsi.exe", "ftp.exe", "gpresult.exe", "ieexec.exe", "iexpress.exe",
                   "installutil.exe", "ipconfig.exe","msxsl.exe", "netsh.exe", "odbcconf.exe", "ping.exe", "pwsh.exe", "qprocess.exe",
                   "quser.exe", "qwinsta.exe", "rcsi.exe", "regasm.exe", "regsvcs.exe", "regsvr32.exe", "sc.exe", "schtasks.exe",
                   "systeminfo.exe", "tracert.exe", "wmic.exe", "wscript.exe","xwizard.exe", "explorer.exe", "msdt.exe") and
 not (process.name : "powershell.exe" and process.args : "-ExecutionPolicy" and process.args : "?:\\TeamCity\\buildAgent\\work\\*.ps1") and
 not (process.name : "cmd.exe" and process.args : "dir" and process.args : "/-c")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)
- Sub Technique:
  - Name: Windows Command Shell
- Id: T1059.003
- Reference URL: [[https://attack.mitre.org/techniques/T1059/003/](https://attack.mitre.org/techniques/T1059/003/)](https://attack.mitre.org/techniques/T1059/003/)