﻿---
title: Suspicious HTML File Creation
description: Identifies the execution of a browser process to open an HTML file with high entropy and size. Adversaries may smuggle data and files past content filters...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_evasion_suspicious_htm_file_creation
products:
  - Elastic Security
---

# Suspicious HTML File Creation
Identifies the execution of a browser process to open an HTML file with high entropy and size. Adversaries may smuggle
data and files past content filters by hiding malicious payloads inside of seemingly benign HTML files.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious HTML File Creation

HTML files, typically used for web content, can be exploited by adversaries to smuggle malicious payloads past security filters. By embedding harmful data within seemingly benign HTML files, attackers can bypass traditional defenses. The detection rule identifies such threats by monitoring the creation of HTML files with unusual characteristics, such as high entropy or large size, in common download and temporary directories. It also tracks browser processes that open these files, ensuring that any suspicious activity is flagged for further investigation. This approach helps in identifying potential phishing attempts and other initial access tactics used by attackers.

### Possible investigation steps

- Review the file creation or rename event details to confirm the file extension is .htm or .html and check if the file's entropy is 5 or higher or if the file size is 150,000 bytes or more.
- Verify the file path to ensure it is located in one of the common download or temporary directories specified in the rule, such as "?:\Users*\Downloads*" or "?:\Users*\AppData\Local\Temp*".
- Examine the process start event to identify the browser process involved, ensuring it matches one of the specified browsers like chrome.exe or firefox.exe, and check if the process arguments align with the rule's conditions.
- Investigate the user.id associated with the sequence to determine if the activity aligns with the user's typical behavior or if it appears suspicious.
- Check for any recent phishing attempts or suspicious emails received by the user that could have led to the download and execution of the HTML file.
- Analyze the content of the HTML file for any embedded scripts or links that could indicate malicious intent or payload delivery.


### False positive analysis

- Legitimate large HTML files downloaded from trusted sources may trigger the rule. Users can create exceptions for specific trusted domains or file hashes to prevent these from being flagged.
- HTML files generated by certain applications or services, such as email clients or document converters, might have high entropy due to embedded data. Identify these applications and exclude their file creation paths from monitoring.
- Temporary HTML files created during software updates or installations in the AppData or Temp directories can be mistaken for suspicious activity. Monitor and whitelist known update processes to reduce false positives.
- Browser extensions or plugins that save web content locally might create HTML files with characteristics similar to those flagged by the rule. Review and whitelist extensions that are known to be safe and necessary for business operations.
- Automated scripts or tools that process web content and save it as HTML files could be misidentified. Ensure these scripts are documented and their file paths are excluded from the rule's scope.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat and to contain any malicious activity.
- Terminate any suspicious browser processes identified in the alert to stop the execution of potentially harmful HTML files.
- Quarantine the suspicious HTML files detected in the specified directories to prevent accidental execution or further access by users.
- Conduct a thorough scan of the affected system using updated antivirus and anti-malware tools to identify and remove any additional threats or malicious payloads.
- Review and analyze the system and network logs to identify any lateral movement or additional compromised systems, escalating findings to the security team for further investigation.
- Restore any affected files or systems from known good backups to ensure the integrity and availability of data and services.
- Implement additional monitoring and alerting for similar activities, focusing on high entropy and large HTML files in common download and temporary directories to enhance detection capabilities.

This rule may have a low to medium performance impact due variety of file paths potentially matching each EQL sequence.

## Rule Query

```eql
sequence by user.id with maxspan=2m

 [file where host.os.type == "windows" and event.action in ("creation", "rename") and

  /* Check for HTML files with high entropy and size */
  file.extension : ("htm", "html") and ((file.Ext.entropy >= 5 and file.size >= 150000) or file.size >= 1000000) and

  /* Check for file paths in common download and temporary directories */
  file.path : (
    "?:\\Users\\*\\Downloads\\*",
    "?:\\Users\\*\\Content.Outlook\\*",
    "?:\\Users\\*\\AppData\\Local\\Temp\\Temp?_*",
    "?:\\Users\\*\\AppData\\Local\\Temp\\7z*",
    "?:\\Users\\*\\AppData\\Local\\Temp\\Rar$*")]
 [process where host.os.type == "windows" and event.action == "start" and
  (
   /* Check for browser processes opening HTML files with single argument */
   (process.name in ("chrome.exe", "msedge.exe", "brave.exe", "whale.exe", "browser.exe", "dragon.exe", "vivaldi.exe", "opera.exe")
    and process.args == "--single-argument") or

   /* Optionally, check for browser processes opening HTML files with two arguments */
   (process.name == "iexplore.exe" and process.args_count == 2) or

   /* Optionally, check for browser processes opening HTML files with URL argument */
   (process.name in ("firefox.exe", "waterfox.exe") and process.args == "-url")
  )
  /* Check for file paths in common download and temporary directories targeted in the process arguments */
  and process.args : ("?:\\Users\\*\\Downloads\\*.htm*",
                      "?:\\Users\\*\\Content.Outlook\\*.htm*",
                      "?:\\Users\\*\\AppData\\Local\\Temp\\Temp?_*.htm*",
                      "?:\\Users\\*\\AppData\\Local\\Temp\\7z*.htm*",
                      "?:\\Users\\*\\AppData\\Local\\Temp\\Rar$*.htm*")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Sub Technique:
  - Name: HTML Smuggling
- Id: T1027.006
- Reference URL: [[https://attack.mitre.org/techniques/T1027/006/](https://attack.mitre.org/techniques/T1027/006/)](https://attack.mitre.org/techniques/T1027/006/)