﻿---
title: High Number of Process and/or Service Terminations
description: This rule identifies a high number (10) of process terminations (stop, delete, or suspend) from the same host within a short time period. Rule type: threshold...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_stop_process_service_threshold
products:
  - Elastic Security
---

# High Number of Process and/or Service Terminations
This rule identifies a high number (10) of process terminations (stop, delete, or suspend) from the same host within a
short time period.
**Rule type**: threshold
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/luna-ransomware-attack-pattern](https://www.elastic.co/security-labs/luna-ransomware-attack-pattern)](https://www.elastic.co/security-labs/luna-ransomware-attack-pattern)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Impact
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Windows Security Event Logs

**Version**: 216
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating High Number of Process and/or Service Terminations

Attackers can stop services and kill processes for a variety of purposes. For example, they can stop services associated with business applications and databases to release the lock on files used by these applications so they may be encrypted, or stop security and backup solutions, etc.
This rule identifies a high number (10) of service and/or process terminations (stop, delete, or suspend) from the same host within a short time period.

#### Possible investigation steps

- Investigate the script execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Check if any files on the host machine have been encrypted.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further destructive behavior, which is commonly associated with this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Reimage the host operating system or restore it to the operational state.
- If any other destructive action was identified on the host, it is recommended to prioritize the investigation and look for ransomware preparation and execution activities.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.category:process and host.os.type:windows and event.type:start and process.name:(net.exe or sc.exe or taskkill.exe) and
 process.args:(stop or pause or delete or "/PID" or "/IM" or "/T" or "/F" or "/t" or "/f" or "/im" or "/pid") and
 not process.parent.name:(osquerybeat.exe or agentbeat.exe)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Service Stop
- Id: T1489
- Reference URL: [[https://attack.mitre.org/techniques/T1489/](https://attack.mitre.org/techniques/T1489/)](https://attack.mitre.org/techniques/T1489/)