﻿---
title: Potential System Tampering via File Modification
description: Identifies attempts to delete or modify critical files used during the boot process to prevent the system from booting. This may indicate a destructive...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_mod_critical_os_files
products:
  - Elastic Security
---

# Potential System Tampering via File Modification
Identifies attempts to delete or modify critical files used during the boot process to prevent the system from booting.
This may indicate a destructive attack behavior.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Impact
- Data Source: Elastic Endgame
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential System Tampering via File Modification

This rule identifies attempts to delete or modify critical files used during the boot process to prevent the system from booting.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes.
- Assess all deleted or modified system critical files and perform a complete recovery of those files to prevent system booting issues.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Identify the user account that performed the action and whether it should perform this kind of action, if not immedialy disable the account.


### False positive analysis

- Analysts can dismiss the alert if the administrator is aware of the activity, no other suspicious activity was identified, and there are justifications for the execution.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
  - Prioritize cases involving critical servers and users.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- If important data was encrypted, deleted, or modified, activate your data recovery plan.
  - Perform data recovery locally or restore the backups from replicated copies (cloud, other servers, etc.).
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Review the privileges assigned to the user to ensure that the least privilege principle is being followed.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
file where host.os.type == "windows" and event.type in ("change", "deletion") and
  file.name : ("winload.exe", "winlod.efi", "ntoskrnl.exe", "bootmgr") and
  file.path : ("?:\\Windows\\*", "\\Device\\HarddiskVolume*\\Windows\\*") and
  not process.executable : (
    "?:\\Windows\\System32\\poqexec.exe",
    "?:\\Windows\\WinSxS\\amd64_microsoft-windows-servicingstack_*\\tiworker.exe"
  ) and
  not file.path : (
    "?:\\Windows\\WinSxS\\Temp\\InFlight\\*",
    "?:\\Windows\\SoftwareDistribution\\Download*",
    "?:\\Windows\\WinSxS\\amd64_microsoft-windows*",
    "?:\\Windows\\SystemTemp\\*",
    "?:\\Windows\\Temp\\????????.???\\*",
    "?:\\Windows\\Temp\\*\\amd64_microsoft-windows-*"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Destruction
- Id: T1485
- Reference URL: [[https://attack.mitre.org/techniques/T1485/](https://attack.mitre.org/techniques/T1485/)](https://attack.mitre.org/techniques/T1485/)
- Technique:
  - Name: Inhibit System Recovery
- Id: T1490
- Reference URL: [[https://attack.mitre.org/techniques/T1490/](https://attack.mitre.org/techniques/T1490/)](https://attack.mitre.org/techniques/T1490/)