﻿---
title: Potential Ransomware Behavior - Note Files by System
description: This rule identifies the creation of multiple files with same name and over SMB by the same user. This behavior may indicate the successful remote execution...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_high_freq_file_renames_by_kernel
products:
  - Elastic Security
---

# Potential Ransomware Behavior - Note Files by System
This rule identifies the creation of multiple files with same name and over SMB by the same user. This behavior may indicate the
successful remote execution of a ransomware dropping file notes to different folders.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://news.sophos.com/en-us/2023/12/21/akira-again-the-ransomware-that-keeps-on-taking/](https://news.sophos.com/en-us/2023/12/21/akira-again-the-ransomware-that-keeps-on-taking/)](https://news.sophos.com/en-us/2023/12/21/akira-again-the-ransomware-that-keeps-on-taking/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Impact
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 213
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


#### Possible investigation steps

- Investigate the content of the dropped files.
- Investigate any file names with unusual extensions.
- Investigate any incoming network connection to port 445 on this host.
- Investigate any network logon events to this host.
- Identify the total number and type of modified files by pid 4.
- If the number of files is too high and source.ip connecting over SMB is unusual isolate the host and block the used credentials.
- Investigate other alerts associated with the user/host during the past 48 hours.


### False positive analysis

- Local file modification from a Kernel mode driver.


### Related rules

- Third-party Backup Files Deleted via Unexpected Process - 11ea6bec-ebde-4d71-a8e9-784948f8e3e9
- Volume Shadow Copy Deleted or Resized via VssAdmin - b5ea4bfe-a1b2-421f-9d47-22a75a6f2921
- Volume Shadow Copy Deletion via PowerShell - d99a037b-c8e2-47a5-97b9-170d076827c4
- Volume Shadow Copy Deletion via WMIC - dc9c1f74-dac3-48e3-b47f-eb79db358f57
- Potential Ransomware Note File Dropped via SMB - 02bab13d-fb14-4d7c-b6fe-4a28874d37c5
- Suspicious File Renamed via SMB - 78e9b5d5-7c07-40a7-a591-3dbbf464c386


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Consider isolating the involved host to prevent destructive behavior, which is commonly associated with this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- If any other destructive action was identified on the host, it is recommended to prioritize the investigation and look for ransomware preparation and execution activities.
- If any backups were affected:
  - Perform data recovery locally or restore the backups from replicated copies (cloud, other servers, etc.).
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```esql
from logs-endpoint.events.file-* metadata _id, _version, _index

// filter for file creation event done remotely over SMB with common user readable file types used to place ransomware notes
| where event.category == "file" and host.os.type == "windows" and event.action == "creation" and process.pid == 4 and user.id != "S-1-5-18" and 
  file.extension in ("txt", "htm", "html", "hta", "pdf", "jpg", "bmp", "png") and
  to_lower(file.path) like """c:\\*""" and not to_lower(file.path) like """c:\\temp\\*"""

// truncate the timestamp to a 60-second window
| eval Esql.time_window_date_trunc = date_trunc(60 seconds, @timestamp)

| keep user.id, user.name, file.path, file.name, process.entity_id, Esql.time_window_date_trunc, host.name, host.ip, host.id

// filter for same file name dropped in at least 3 unique paths by the System virtual process
| stats Esql.file_path_count_distinct = COUNT_DISTINCT(file.path),  Esql.file_path_values = VALUES(file.path), Esql.host_ip_values = values(host.ip) by host.id, host.name, user.name, user.id, process.entity_id , file.name, Esql.time_window_date_trunc
| where Esql.file_path_count_distinct >= 3
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Destruction
- Id: T1485
- Reference URL: [[https://attack.mitre.org/techniques/T1485/](https://attack.mitre.org/techniques/T1485/)](https://attack.mitre.org/techniques/T1485/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)
- Sub Technique:
  - Name: SMB/Windows Admin Shares
- Id: T1021.002
- Reference URL: [[https://attack.mitre.org/techniques/T1021/002/](https://attack.mitre.org/techniques/T1021/002/)](https://attack.mitre.org/techniques/T1021/002/)