﻿---
title: Suspicious Windows Powershell Arguments
description: Identifies the execution of PowerShell with suspicious argument values. This behavior is often observed during malware installation leveraging PowerShell...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_powershell_susp_args
products:
  - Elastic Security
---

# Suspicious Windows Powershell Arguments
Identifies the execution of PowerShell with suspicious argument values. This behavior is often observed during malware
installation leveraging PowerShell.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-crowdstrike.fdr*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Windows Security Event Logs
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 210
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Windows Powershell Arguments

PowerShell is a powerful scripting language and command-line shell used for task automation and configuration management in Windows environments. Adversaries exploit PowerShell's capabilities to execute malicious scripts, download payloads, and obfuscate commands. The detection rule identifies unusual PowerShell arguments indicative of such abuse, focusing on patterns like encoded commands, suspicious downloads, and obfuscation techniques, thereby flagging potential threats for further investigation.

### Possible investigation steps

- Review the process command line and arguments to identify any encoded or obfuscated content, such as Base64 strings or unusual character sequences, which may indicate malicious intent.
- Check the parent process of the PowerShell execution, especially if it is explorer.exe or cmd.exe, to determine if the PowerShell instance was launched from a suspicious or unexpected source.
- Investigate any network activity associated with the PowerShell process, particularly looking for connections to known malicious domains or IP addresses, or the use of suspicious commands like DownloadFile or DownloadString.
- Examine the user account associated with the PowerShell execution to determine if it aligns with expected behavior or if it might be compromised.
- Correlate the event with other security alerts or logs from the same host or user to identify patterns or additional indicators of compromise.
- Assess the risk and impact of the detected activity by considering the context of the environment, such as the presence of sensitive data or critical systems that might be affected.


### False positive analysis

- Legitimate administrative scripts may use encoded commands for obfuscation to protect sensitive data. Review the script's source and purpose to determine if it is authorized. If confirmed, add the script's hash or specific command pattern to an allowlist.
- Automated software deployment tools might use PowerShell to download and execute scripts from trusted internal sources. Verify the source and destination of the download. If legitimate, exclude the specific tool or process from the detection rule.
- System maintenance tasks often involve PowerShell scripts that manipulate files or system settings. Identify routine maintenance scripts and exclude their specific command patterns or file paths from triggering the rule.
- Security software may use PowerShell for scanning or remediation tasks, which can mimic suspicious behavior. Confirm the software's legitimacy and add its processes to an exception list to prevent false alerts.
- Developers might use PowerShell for testing or development purposes, which can include obfuscation techniques. Validate the developer's activities and exclude their specific development environments or scripts from the rule.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further spread or communication with potential command and control servers.
- Terminate any suspicious PowerShell processes identified by the detection rule to halt ongoing malicious activities.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any malicious payloads or scripts.
- Review and clean up any unauthorized changes to system configurations or scheduled tasks that may have been altered by the malicious PowerShell activity.
- Restore any affected files or system components from known good backups to ensure system integrity and functionality.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems are compromised.
- Implement additional monitoring and logging for PowerShell activities across the network to enhance detection of similar threats in the future.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
 process.name : "powershell.exe" and

  not (
    ?user.id == "S-1-5-18" and
    /* Don't apply the user.id exclusion to Sysmon for compatibility */
    not event.dataset : ("windows.sysmon_operational", "windows.sysmon")
  ) and

  (
    process.command_line : (
          "*^*^*^*^*^*^*^*^*^*",
          "*`*`*`*`*",
          "*+*+*+*+*+*+*",
          "*[char[]](*)*-join*",
          "*Base64String*",
          "*[*Convert]*",
          "*.Compression.*",
          "*-join($*",
          "*.replace*",
          "*MemoryStream*",
          "*WriteAllBytes*",
          "* -enc *",
          "* -ec *",
          "* /e *",
          "* /enc *",
          "* /ec *",
          "*WebClient*",
          "*DownloadFile*",
          "*DownloadString*",
          "* iex*",
          "* iwr*",
          "* aQB3AHIAIABpA*",
          "*Reflection.Assembly*",
          "*Assembly.GetType*",
          "*$env:temp\\*start*",
          "*powercat*",
          "*nslookup -q=txt*",
          "*$host.UI.PromptForCredential*",
          "*Net.Sockets.TCPClient*",
          "*curl *;Start*",
          "powershell.exe \"<#*",
          "*ssh -p *",
          "*http*|iex*",
          "*@SSL\\DavWWWRoot\\*.ps1*",
          "*.lnk*.Seek(0x*",
          "*[string]::join(*",
          "*[Array]::Reverse($*",
          "* hidden $(gc *",
          "*=wscri& set*",
          "*http'+'s://*",
          "*.content|i''Ex*",
          "*//:sptth*",
          "*//:ptth*",
          "*h''t''t''p*",
          "*'tp'':''/'*",
          "*$env:T\"E\"MP*",
          "*;cmd /c $?",
          "*s''t''a''r*",
          "*$*=Get-Content*AppData*.SubString(*$*",
          "*=cat *AppData*.substring(*);*$*",
          "*-join'';*|powershell*",
          "*.Content;sleep *|powershell*",
          "*h\''t\''tp:\''*",
          "*-e aQB3AHIAIABp*",
          "*iwr *https*).Content*",
          "*$env:computername*http*",
          "*;InVoKe-ExpRESsIoN $COntent.CONTENt;*",
          "*WebClient*example.com*",
          "*=iwr $*;iex $*",
          "*ServerXmlHttp*IEX*",
          "*XmlDocument*IEX*"
    ) or

    (process.args : "-c" and process.args : "&{'*") or

    (process.args : "-Outfile" and process.args : "Start*") or

    (process.args : "-bxor" and process.args : "0x*") or

    process.args : "$*$*;set-alias" or

    process.args == "-e" or

    // ATHPowerShellCommandLineParameter
    process.args : ("-EncodedCommandParamVariation", "-UseEncodedArguments", "-CommandParamVariation") or

    (
      process.parent.name : ("explorer.exe", "cmd.exe") and
      process.command_line : ("*-encodedCommand*", "*Invoke-webrequest*", "*WebClient*", "*Reflection.Assembly*"))
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)