﻿---
title: Execution via local SxS Shared Module
description: Identifies the creation, change, or deletion of a DLL module within a Windows SxS local folder. Adversaries may abuse shared modules to execute malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_shared_modules_local_sxs_dll
products:
  - Elastic Security
---

# Execution via local SxS Shared Module
Identifies the creation, change, or deletion of a DLL module within a Windows SxS local folder. Adversaries may abuse
shared modules to execute malicious payloads by instructing the Windows module loader to load DLLs from arbitrary local
paths.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/windows/win32/dlls/dynamic-link-library-redirection](https://docs.microsoft.com/en-us/windows/win32/dlls/dynamic-link-library-redirection)](https://docs.microsoft.com/en-us/windows/win32/dlls/dynamic-link-library-redirection)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 312
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis

The SxS DotLocal folder is a legitimate feature that can be abused to hijack standard modules loading order by forcing an executable on the same application.exe.local folder to load a malicious DLL module from the same directory.

## Rule Query

```eql
file where host.os.type == "windows" and file.extension : "dll" and
  file.path : (
    "C:\\*\\*.exe.local\\*.dll",
    /* Crowdstrike specific condition as it uses NT Object paths */
    "\\Device\\HarddiskVolume*\\*\\*.exe.local\\*.dll"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Shared Modules
- Id: T1129
- Reference URL: [[https://attack.mitre.org/techniques/T1129/](https://attack.mitre.org/techniques/T1129/)](https://attack.mitre.org/techniques/T1129/)