﻿---
title: Windows Script Execution from Archive
description: Identifies attempts to execute Jscript/Vbscript files from an archive file. The use of archives is a common delivery method of malicious scripts. Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_scripts_archive_file
products:
  - Elastic Security
---

# Windows Script Execution from Archive
Identifies attempts to execute Jscript/Vbscript files from an archive file. The use of archives is a common delivery method
of malicious scripts.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://medium.com/walmartglobaltech/smartapesg-4605157a5b80](https://medium.com/walmartglobaltech/smartapesg-4605157a5b80)](https://medium.com/walmartglobaltech/smartapesg-4605157a5b80)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Windows Script Execution from Archive

Windows scripts, often used for legitimate automation tasks, can be exploited by adversaries to execute malicious code. Attackers may download scripts via browsers or file utilities, then execute them using scripting tools like wscript or mshta. The detection rule identifies such threats by monitoring script creation from internet sources and subsequent execution, focusing on unusual parent-child process relationships and script attributes.

### Possible investigation steps

- Review the file creation event to identify the specific script file that was downloaded, noting its name, path, and extension to understand the potential threat.
- Examine the origin URL or referrer URL of the downloaded script to determine the source and assess its legitimacy or potential malicious intent.
- Investigate the parent process, such as chrome.exe or explorer.exe, to understand how the script was downloaded and whether it aligns with typical user behavior.
- Analyze the execution event of the scripting utility (wscript.exe or mshta.exe) to identify the command-line arguments used, which may provide insight into the script's intended actions.
- Check the user account associated with the script execution to determine if the activity is expected for that user or if it indicates a compromised account.
- Correlate the timing of the script creation and execution events to see if they fall within a suspicious timeframe, such as outside of normal working hours.
- Look for any additional related alerts or logs on the host that might indicate further malicious activity or lateral movement following the script execution.


### False positive analysis

- Legitimate script automation tools may trigger this rule if they download and execute scripts from the internet. Users can create exceptions for known safe tools by excluding specific file paths or process names.
- Software updates or installations that download scripts as part of their process might be flagged. To handle this, users can whitelist specific origin URLs or referrer URLs associated with trusted software vendors.
- Internal scripts distributed via corporate intranet sites could be misidentified as threats. Users should consider excluding scripts with known internal origin URLs or specific user IDs associated with IT operations.
- Browser extensions or plugins that automate tasks using scripts may cause false positives. Users can exclude these by identifying and excluding the specific browser process names or file extensions involved.
- Frequent use of file utilities like winrar or 7zFM for legitimate script handling can be excluded by specifying trusted file paths or user IDs that regularly perform these actions.


### Response and remediation

- Isolate the affected system from the network to prevent further execution of potentially malicious scripts and lateral movement.
- Terminate any suspicious processes identified in the alert, such as wscript.exe or mshta.exe, to stop the execution of the downloaded script.
- Quarantine the downloaded script file and any associated files to prevent further execution and facilitate forensic analysis.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious files or remnants.
- Review and analyze the origin URL and referrer URL of the downloaded script to identify potential malicious websites or compromised sources, and block these URLs at the network level.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement application whitelisting to restrict the execution of unauthorized scripts and scripting utilities, reducing the risk of similar threats in the future.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.name : "wscript.exe" and
 process.parent.name : ("explorer.exe", "winrar.exe", "7zFM.exe") and
 process.args :
        ("?:\\Users\\*\\AppData\\Local\\Temp\\7z*\\*",
         "?:\\Users\\*\\AppData\\Local\\Temp\\*.zip.*\\*",
         "?:\\Users\\*\\AppData\\Local\\Temp\\Rar$*\\*",
         "?:\\Users\\*\\AppData\\Local\\Temp\\Temp?_*\\*",
         "?:\\Users\\*\\AppData\\Local\\Temp\\BNZ.*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)
- Sub Technique:
  - Name: Visual Basic
- Id: T1059.005
- Reference URL: [[https://attack.mitre.org/techniques/T1059/005/](https://attack.mitre.org/techniques/T1059/005/)](https://attack.mitre.org/techniques/T1059/005/)