﻿---
title: Potential Malicious PowerShell Based on Alert Correlation
description: Identifies PowerShell script blocks associated with multiple distinct detections, indicating likely malicious behavior. Rule type: esql Rule indices: 
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_malicious_script_agg
products:
  - Elastic Security
---

# Potential Malicious PowerShell Based on Alert Correlation
Identifies PowerShell script blocks associated with multiple distinct detections, indicating likely malicious behavior.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Malicious PowerShell Based on Alert Correlation

This detection rule aggregates alert data to identify PowerShell Scripts that have triggered various PowerShell-related detection logic, thereby producing higher-fidelity results.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

### Possible investigation steps

- Analyzing the detections triggered by the script should offer insight into the suspicious behaviors it exhibits. This information can be found in the `distinct_alerts` field.
- Examine the script content that triggered the detection; look for suspicious DLL imports, collection or exfiltration capabilities, suspicious functions, encoded or compressed data, and other potentially malicious characteristics.
- Investigate the script execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Examine the script's execution context, such as the user account, privileges, the role of the system on which it was executed, and any relevant timestamps.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Evaluate whether the user needs to use PowerShell to complete tasks.
- Investigate the origin of the PowerShell script, including its source, download method, and any associated URLs or IP addresses.
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the script using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process's `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- This rule is unlikely to trigger on legitimate activity. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and Remediation

- Initiate the incident response process based on the outcome of the triage.
  - If malicious activity is confirmed, perform a broader investigation to identify the scope of the compromise and determine the appropriate remediation steps.
- Isolate the involved hosts to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Reimage the host operating system or restore the compromised files to clean versions.
- Restrict PowerShell usage outside of IT and engineering business units using GPOs, AppLocker, Intune, or similar software.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```esql
from .alerts-security.* metadata _id

// Filter for PowerShell related alerts
| where kibana.alert.rule.name like "*PowerShell*"

// as alerts don't have non-ECS fields, parse the script block ID using grok
| grok message "ScriptBlock ID: (?<Esql.script_block_id>.+)"
| where Esql.script_block_id is not null

// keep relevant fields for further processing
| keep kibana.alert.rule.name, Esql.script_block_id, _id

// count distinct alerts and filter for matches above the threshold
| stats
    Esql.kibana_alert_rule_name_count_distinct = count_distinct(kibana.alert.rule.name),
    Esql.kibana_alert_rule_name_values = values(kibana.alert.rule.name),
    Esql._id_values = values(_id)
  by Esql.script_block_id

// Apply detection threshold
| where Esql.kibana_alert_rule_name_count_distinct >= 5
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)