﻿---
title: WPS Office Exploitation via DLL Hijack
description: Identifies the load of a remote library by the WPS Office promecefpluginhost.exe executable. This may indicate the successful exploitation of CVE-2024-7262...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_initial_access_wps_dll_exploit
products:
  - Elastic Security
---

# WPS Office Exploitation via DLL Hijack
Identifies the load of a remote library by the WPS Office promecefpluginhost.exe executable. This may indicate the
successful exploitation of CVE-2024-7262 or CVE-2024-7263 via DLL hijack abusing the ksoqing custom protocol handler.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*
- logs-windows.sysmon_operational-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.welivesecurity.com/en/eset-research/analysis-of-two-arbitrary-code-execution-vulnerabilities-affecting-wps-office/](https://www.welivesecurity.com/en/eset-research/analysis-of-two-arbitrary-code-execution-vulnerabilities-affecting-wps-office/)](https://www.welivesecurity.com/en/eset-research/analysis-of-two-arbitrary-code-execution-vulnerabilities-affecting-wps-office/)
- [[https://mp.weixin.qq.com/s/F8hNyESBdKhwXkQPgtGpew](https://mp.weixin.qq.com/s/F8hNyESBdKhwXkQPgtGpew)](https://mp.weixin.qq.com/s/F8hNyESBdKhwXkQPgtGpew)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Execution
- Data Source: Elastic Defend
- Data Source: Sysmon
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating WPS Office Exploitation via DLL Hijack

DLL hijacking exploits the way applications load dynamic link libraries (DLLs), allowing adversaries to execute malicious code. In WPS Office, attackers may exploit vulnerabilities by loading a rogue DLL via the promecefpluginhost.exe process, leveraging the ksoqing protocol. The detection rule identifies suspicious DLL loads from temporary or network paths, signaling potential exploitation attempts.

### Possible investigation steps

- Review the alert details to confirm the process name is promecefpluginhost.exe and check if the event category is either "library" or "process" with the action "Image loaded*".
- Examine the DLL or file path involved in the alert to determine if it matches suspicious paths such as those in the user's Temp directory or network paths like \Device\Mup\** or \*.
- Investigate the source of the DLL by checking the file's origin, creation date, and any associated network activity to identify potential malicious downloads or transfers.
- Analyze the process tree to understand the parent and child processes of promecefpluginhost.exe, looking for any unusual or unexpected behavior that might indicate exploitation.
- Check for any other alerts or logs related to the same host or user account to identify patterns or repeated attempts of exploitation.
- Correlate the findings with known vulnerabilities CVE-2024-7262 and CVE-2024-7263 to assess if the observed activity aligns with known exploitation techniques.


### False positive analysis

- Legitimate software updates or installations may temporarily load DLLs from network paths or temporary directories. Users can create exceptions for known update processes or trusted software installations to prevent false alerts.
- Some enterprise environments use network-based storage solutions that may trigger alerts when legitimate DLLs are loaded from these paths. Administrators can whitelist specific network paths or devices that are known to host trusted libraries.
- Custom scripts or automation tools that interact with WPS Office might inadvertently load DLLs from temporary directories. Identifying and excluding these scripts or tools from monitoring can reduce false positives.
- Security software or system maintenance tools may perform scans or operations that mimic the behavior of DLL hijacking. Users should verify and exclude these tools if they are known to cause benign alerts.
- In environments where WPS Office is heavily used, consider monitoring the frequency and context of alerts to distinguish between normal usage patterns and potential threats, adjusting the rule parameters accordingly.


### Response and remediation

- Isolate the affected system from the network immediately to prevent further exploitation or lateral movement by the attacker.
- Terminate the promecefpluginhost.exe process to stop any ongoing malicious activity and prevent further DLL hijacking attempts.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any malicious DLLs or other malware.
- Review and clean up the temporary and network paths identified in the detection query, specifically focusing on the AppData\Local\Temp\wps\INetCache directory and any suspicious network shares.
- Apply patches or updates for WPS Office to address the vulnerabilities CVE-2024-7262 and CVE-2024-7263, ensuring that the software is up to date and less susceptible to exploitation.
- Monitor for any further suspicious activity related to the ksoqing protocol or similar DLL hijacking attempts, using enhanced logging and alerting mechanisms.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are compromised.


## Rule Query

```eql
any where host.os.type == "windows" and process.name : "promecefpluginhost.exe" and
(
 (event.category == "library" and
  ?dll.path :
     ("?:\\Users\\*\\AppData\\Local\\Temp\\wps\\INetCache\\*",
      "\\Device\\Mup\\**", "\\\\*")) or

  ((event.category == "process" and event.action : "Image loaded*") and
  ?file.path :
     ("?:\\Users\\*\\AppData\\Local\\Temp\\wps\\INetCache\\*",
      "\\Device\\Mup\\**", "\\\\*"))
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Exploitation for Client Execution
- Id: T1203
- Reference URL: [[https://attack.mitre.org/techniques/T1203/](https://attack.mitre.org/techniques/T1203/)](https://attack.mitre.org/techniques/T1203/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Drive-by Compromise
- Id: T1189
- Reference URL: [[https://attack.mitre.org/techniques/T1189/](https://attack.mitre.org/techniques/T1189/)](https://attack.mitre.org/techniques/T1189/)