﻿---
title: Downloaded Shortcut Files
description: Identifies .lnk shortcut file downloaded from outside the local network. These shortcut files are commonly used in phishing campaigns. Rule type: eql...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_downloaded_shortcut_files
products:
  - Elastic Security
---

# Downloaded Shortcut Files
Identifies .lnk shortcut file downloaded from outside the local network. These shortcut files are commonly used in
phishing campaigns.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Downloaded Shortcut Files

Shortcut files (.lnk) are used in Windows environments to link to executable files or scripts, streamlining user access. Adversaries exploit this by embedding malicious commands in these files, often distributing them via phishing. The detection rule identifies suspicious .lnk files created on Windows systems, especially those downloaded from external sources, indicating potential phishing attempts. This is achieved by monitoring file creation events and zone identifiers, which help trace the file's origin.

### Possible investigation steps

- Review the file creation event details to identify the specific .lnk file and its associated metadata, such as the file path and creation timestamp.
- Examine the zone identifier value to confirm that the file was indeed downloaded from an external source, as indicated by a value greater than 1.
- Investigate the source of the download by checking network logs or browser history to identify the URL or IP address from which the .lnk file was downloaded.
- Analyze the contents of the .lnk file to detect any embedded commands or scripts that may indicate malicious intent.
- Check for any related alerts or events on the same host around the time of the .lnk file creation to identify potential follow-up actions or additional threats.
- Assess the user account associated with the file creation event to determine if the account has been compromised or if the user was targeted in a phishing campaign.


### False positive analysis

- Corporate software deployments may trigger the rule when legitimate .lnk files are distributed across the network. Users can create exceptions for known software distribution servers to prevent these false positives.
- Automated backup or synchronization tools that create .lnk files as part of their normal operation can be mistaken for threats. Identifying and excluding these tools from the rule can reduce unnecessary alerts.
- User-created shortcuts for frequently accessed network resources might be flagged. Monitoring and excluding specific user activities or directories where these shortcuts are commonly created can help manage these false positives.
- Some legitimate applications may download .lnk files as part of their update process. Identifying these applications and adding them to an exception list can prevent false alerts.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat.
- Quarantine the suspicious .lnk file to prevent execution and further analysis.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious files or processes.
- Review and remove any unauthorized or suspicious user accounts or privileges that may have been created or altered as a result of the phishing attempt.
- Restore the system from a known good backup if any critical system files or configurations have been compromised.
- Notify the security team and relevant stakeholders about the incident for awareness and further investigation.
- Update security policies and rules to block similar phishing attempts in the future, such as restricting the execution of .lnk files from untrusted sources.


## Rule Query

```eql
file where host.os.type == "windows" and event.type == "creation" and file.extension == "lnk" and file.Ext.windows.zone_identifier > 1
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)