﻿---
title: Unusual Parent Process for cmd.exe
description: Identifies a suspicious parent child process relationship with cmd.exe descending from an unusual process. Rule type: eql Rule indices: winlogbeat-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_shell_started_by_unusual_process
products:
  - Elastic Security
---

# Unusual Parent Process for cmd.exe
Identifies a suspicious parent child process relationship with cmd.exe descending from an unusual process.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.process-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Resources: Investigation Guide

**Version**: 416
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Parent Process for cmd.exe

Cmd.exe is a command-line interpreter on Windows systems, often used for legitimate administrative tasks. However, adversaries can exploit it by launching it from atypical parent processes to execute malicious commands stealthily. The detection rule identifies such anomalies by flagging cmd.exe instances spawned by uncommon parent processes, which may indicate unauthorized or suspicious activity, thus aiding in early threat detection.

### Possible investigation steps

- Review the process tree to understand the context in which cmd.exe was launched, focusing on the parent process identified in the alert.
- Investigate the parent process by examining its command-line arguments, start time, and any associated network activity to determine if it is behaving anomalously.
- Check the historical behavior of the parent process to see if it has previously spawned cmd.exe or if this is an unusual occurrence.
- Analyze any child processes spawned by the cmd.exe instance to identify potentially malicious activities or commands executed.
- Correlate the alert with other security events or logs from the same host to identify any related suspicious activities or patterns.
- Assess the user account associated with the cmd.exe process to determine if it has been compromised or is exhibiting unusual behavior.
- Consult threat intelligence sources to see if the parent process or its behavior is associated with known malware or attack techniques.


### False positive analysis

- Cmd.exe instances spawned by legitimate system maintenance tools like Windows Update or system indexing services can trigger false positives. Users can create exceptions for processes like SearchIndexer.exe or WUDFHost.exe if they are verified as part of routine system operations.
- Software updates or installations that use cmd.exe for scripting purposes might be flagged. If GoogleUpdate.exe or FlashPlayerUpdateService.exe are known to be part of regular update processes, consider excluding them after confirming their legitimacy.
- Administrative scripts or tools that are scheduled to run via Task Scheduler might use cmd.exe and be flagged. If taskhostw.exe is a known parent process for these tasks, verify and exclude it to prevent unnecessary alerts.
- Certain third-party applications might use cmd.exe for legitimate background tasks. If applications like jusched.exe or jucheck.exe are identified as part of trusted software, they can be excluded after validation.
- System recovery or diagnostic tools that interact with cmd.exe could be misidentified. If WerFault.exe or wermgr.exe are part of these processes, ensure they are legitimate and exclude them accordingly.


### Response and remediation

- Immediately isolate the affected system from the network to prevent potential lateral movement by the adversary.
- Terminate the suspicious cmd.exe process and its parent process to halt any ongoing malicious activity.
- Conduct a thorough review of the affected system's recent activity logs to identify any unauthorized changes or additional compromised processes.
- Restore any altered or deleted files from a known good backup to ensure system integrity.
- Update and run a full antivirus and anti-malware scan on the affected system to detect and remove any additional threats.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for cmd.exe and its parent processes to detect similar anomalies in the future.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : "cmd.exe" and
  process.parent.name : ("lsass.exe",
                         "csrss.exe",
                         "epad.exe",
                         "regsvr32.exe",
                         "dllhost.exe",
                         "LogonUI.exe",
                         "wermgr.exe",
                         "spoolsv.exe",
                         "jucheck.exe",
                         "jusched.exe",
                         "ctfmon.exe",
                         "taskhostw.exe",
                         "GoogleUpdate.exe",
                         "sppsvc.exe",
                         "sihost.exe",
                         "slui.exe",
                         "SIHClient.exe",
                         "SearchIndexer.exe",
                         "SearchProtocolHost.exe",
                         "FlashPlayerUpdateService.exe",
                         "WerFault.exe",
                         "WUDFHost.exe",
                         "unsecapp.exe",
                         "wlanext.exe" ) and
  not (process.parent.name : "dllhost.exe" and process.parent.args : "/Processid:{CA8C87C1-929D-45BA-94DB-EF8E6CB346AD}")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)