﻿---
title: Svchost spawning Cmd
description: Identifies a suspicious parent child process relationship with cmd.exe descending from svchost.exe Rule type: new_terms Rule indices: logs-endpoint.events.process-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_shell_started_by_svchost
products:
  - Elastic Security
---

# Svchost spawning Cmd
Identifies a suspicious parent child process relationship with cmd.exe descending from svchost.exe
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process-*
- winlogbeat-*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-system.security*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://nasbench.medium.com/demystifying-the-svchost-exe-process-and-its-command-line-options-508e9114e747](https://nasbench.medium.com/demystifying-the-svchost-exe-process-and-its-command-line-options-508e9114e747)](https://nasbench.medium.com/demystifying-the-svchost-exe-process-and-its-command-line-options-508e9114e747)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne

**Version**: 425
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Svchost spawning Cmd

The Service Host process (SvcHost) is a system process that can host one, or multiple, Windows services in the Windows NT family of operating systems. Note that `Svchost.exe` is reserved for use by the operating system and should not be used by non-Windows services.
This rule looks for the creation of the `cmd.exe` process with `svchost.exe` as its parent process. This is an unusual behavior that can indicate the masquerading of a malicious process as `svchost.exe` or exploitation for privilege escalation.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate any abnormal behavior by the subject process such as network connections, registry or file modifications, and any spawned child processes.
- Examine the host for derived artifacts that indicate suspicious activities:
  - Analyze the process executable using a private sandboxed analysis system.
- Observe and collect information about the following activities in both the sandbox and the alert subject host:
  - Attempts to contact external domains and addresses.
  - Use the Elastic Defend network events to determine domains and addresses contacted by the subject process by filtering by the process' `process.entity_id`.
- Examine the DNS cache for suspicious or anomalous entries.
  - $osquery_0
- Use the Elastic Defend registry events to examine registry keys accessed, modified, or created by the related processes in the process tree.
- Examine the host services for suspicious or anomalous entries.
  - $osquery_1
- $osquery_2
- $osquery_3
- Retrieve the files' SHA-256 hash values using the PowerShell `Get-FileHash` cmdlet and search for the existence and reputation of the hashes in resources like VirusTotal, Hybrid-Analysis, CISCO Talos, Any.run, etc.
- Investigate potentially compromised accounts. Analysts can do this by searching for login events (for example, 4624) to the target host after the registry modification.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- If the triage identified malware, search the environment for additional compromised hosts.
  - Implement temporary network rules, procedures, and segmentation to contain the malware.
- Stop suspicious processes.
- Immediately block the identified indicators of compromise (IoCs).
- Inspect the affected systems for additional malware backdoors like reverse shells, reverse proxies, or droppers that attackers could use to reinfect the system.
- Remove and block malicious artifacts identified during triage.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
host.os.type:windows and event.category:process and event.type:start and process.parent.name:svchost.exe and 
process.name:(CMD.EXE or Cmd.exe or cmd.exe) and 
process.command_line:(* and not "\"cmd.exe\" /C sc control hptpsmarthealthservice 211") and 
not process.args:(".\inetsrv\iissetup.exe /keygen " or "C:\Program" or "C:\Program Files (x86)\Kaspersky Lab\NetworkAgent\klmover.exe" or "C:\Program Files (x86)\Sentry\SA\adluminupdater.exe" or "C:\Program Files\WinRAR" or "C:\Program Files\WinRAR\uninstall.exe" or "hpdiags://BatteryStatusTest" or hptpsmarthealthservice or icacls or taskkill or w32tm or *.BAT* or *.CMD* or *.bat* or *.cmd*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)