﻿---
title: System Public IP Discovery via DNS Query
description: Identifies DNS queries to known public IP address lookup web services. Malwares tend to perform this action to assess potential targets. Rule type: eql...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_host_public_ip_address_lookup
products:
  - Elastic Security
---

# System Public IP Discovery via DNS Query
Identifies DNS queries to known public IP address lookup web services. Malwares tend to perform this action to assess potential targets.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.network-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Data Source: Sysmon

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating System Public IP Discovery via DNS Query


#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes or malicious scripts.
- Verify if the executed process is persistent on the host like common mechanisms Startup folder, task or Run key.
- Review any unusual network, files or registry events by the same process.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Extract this communication's indicators of compromise (IoCs) and use traffic logs to search for other potentially compromised hosts.


### False positive analysis

- Trusted domain from an expected process running in the environment.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Immediately block the identified indicators of compromise (IoCs).
- Implement any temporary network rules, procedures, and segmentation required to contain the attack.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Update firewall rules to be more restrictive.
- Reimage the host operating system or restore the compromised files to clean versions.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
network where host.os.type == "windows" and dns.question.name != null and process.name != null and
(
  process.name : ("MSBuild.exe", "mshta.exe", "wscript.exe", "powershell.exe", "pwsh.exe", "msiexec.exe", "rundll32.exe",
  "bitsadmin.exe", "InstallUtil.exe", "RegAsm.exe", "vbc.exe", "RegSvcs.exe", "python.exe", "regsvr32.exe", "dllhost.exe",
  "node.exe", "javaw.exe", "java.exe", "*.pif", "*.com") or

  (?process.code_signature.trusted == false or ?process.code_signature.exists == false) or

  ?process.code_signature.subject_name : ("AutoIt Consulting Ltd", "OpenJS Foundation", "Python Software Foundation") or

  ?process.executable : ("?:\\Users\\*.exe", "?:\\ProgramData\\*.exe")
 ) and
 dns.question.name :
         (
          "ip-api.com",
          "checkip.dyndns.org",
          "api.ipify.org",
          "api.ipify.com",
          "whatismyip.akamai.com",
          "bot.whatismyipaddress.com",
          "ifcfg.me",
          "ident.me",
          "ipof.in",
          "ip.tyk.nu",
          "icanhazip.com",
          "curlmyip.com",
          "wgetip.com",
          "eth0.me",
          "ipecho.net",
          "ip.appspot.com",
          "api.myip.com",
          "geoiptool.com",
          "api.2ip.ua",
          "api.ip.sb",
          "ipinfo.io",
          "checkip.amazonaws.com",
          "wtfismyip.com",
          "iplogger.*",
          "freegeoip.net",
          "freegeoip.app",
          "ipinfo.io",
          "geoplugin.net",
          "myip.dnsomatic.com",
          "www.geoplugin.net",
          "api64.ipify.org",
          "ip4.seeip.org",
          "*.geojs.io",
          "*portmap.io",
          "api.2ip.ua",
          "api.db-ip.com",
          "geolocation-db.com",
          "httpbin.org",
          "myip.opendns.com"
         )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Configuration Discovery
- Id: T1016
- Reference URL: [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Sub Technique:
  - Name: DNS
- Id: T1071.004
- Reference URL: [[https://attack.mitre.org/techniques/T1071/004/](https://attack.mitre.org/techniques/T1071/004/)](https://attack.mitre.org/techniques/T1071/004/)