﻿---
title: Active Directory Discovery using AdExplorer
description: This rule detects the use of ADExplorer utility. Active Directory Explorer (AD Explorer) is an advanced Active Directory (AD) viewer and editor. AD Explorer...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_ad_explorer_execution
products:
  - Elastic Security
---

# Active Directory Discovery using AdExplorer
This rule detects the use of ADExplorer utility. Active Directory Explorer (AD Explorer) is an advanced Active Directory (AD)
viewer and editor. AD Explorer also includes the ability to save snapshots of an AD database for off-line viewing and comparisons.
Adversaries may abuse this utility to perform domain reconnaissance.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://learn.microsoft.com/en-us/sysinternals/downloads/adexplorer](https://learn.microsoft.com/en-us/sysinternals/downloads/adexplorer)](https://learn.microsoft.com/en-us/sysinternals/downloads/adexplorer)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Active Directory Discovery using AdExplorer

Active Directory Explorer (AD Explorer) is an advanced Active Directory (AD) viewer and editor. AD Explorer also includes the ability to save snapshots of an AD database for off-line viewing and comparisons.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Verify any file creation, this may indicate the creation of an AD snapshot.
- Identify when the AdExplorer binary was dropped and by what process reviewing file creation events.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.


### False positive analysis

- This rule has a high chance to produce false positives as it is a legitimate tool used by system administrators.
- If this rule is noisy in your environment due to expected activity, consider adding exceptions — preferably with a combination of user and process path conditions.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (process.name : "ADExplorer*.exe" or ?process.pe.original_file_name == "AdExp")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Network Configuration Discovery
- Id: T1016
- Reference URL: [[https://attack.mitre.org/techniques/T1016/](https://attack.mitre.org/techniques/T1016/)](https://attack.mitre.org/techniques/T1016/)
- Technique:
  - Name: Remote System Discovery
- Id: T1018
- Reference URL: [[https://attack.mitre.org/techniques/T1018/](https://attack.mitre.org/techniques/T1018/)](https://attack.mitre.org/techniques/T1018/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)
- Sub Technique:
  - Name: Domain Groups
- Id: T1069.002
- Reference URL: [[https://attack.mitre.org/techniques/T1069/002/](https://attack.mitre.org/techniques/T1069/002/)](https://attack.mitre.org/techniques/T1069/002/)
- Technique:
  - Name: Account Discovery
- Id: T1087
- Reference URL: [[https://attack.mitre.org/techniques/T1087/](https://attack.mitre.org/techniques/T1087/)](https://attack.mitre.org/techniques/T1087/)
- Sub Technique:
  - Name: Domain Account
- Id: T1087.002
- Reference URL: [[https://attack.mitre.org/techniques/T1087/002/](https://attack.mitre.org/techniques/T1087/002/)](https://attack.mitre.org/techniques/T1087/002/)
- Technique:
  - Name: Domain Trust Discovery
- Id: T1482
- Reference URL: [[https://attack.mitre.org/techniques/T1482/](https://attack.mitre.org/techniques/T1482/)](https://attack.mitre.org/techniques/T1482/)