﻿---
title: Signed Proxy Execution via MS Work Folders
description: Identifies the use of Windows Work Folders to execute a potentially masqueraded control.exe file in the current working directory. Misuse of Windows Work...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_workfolders_control_execution
products:
  - Elastic Security
---

# Signed Proxy Execution via MS Work Folders
Identifies the use of Windows Work Folders to execute a potentially masqueraded control.exe file in the current working
directory. Misuse of Windows Work Folders could indicate malicious activity.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/windows-server/storage/work-folders/work-folders-overview](https://docs.microsoft.com/en-us/windows-server/storage/work-folders/work-folders-overview)](https://docs.microsoft.com/en-us/windows-server/storage/work-folders/work-folders-overview)
- [[https://twitter.com/ElliotKillick/status/1449812843772227588](https://twitter.com/ElliotKillick/status/1449812843772227588)](https://twitter.com/ElliotKillick/status/1449812843772227588)
- [[https://lolbas-project.github.io/lolbas/Binaries/WorkFolders/](https://lolbas-project.github.io/lolbas/Binaries/WorkFolders/)](https://lolbas-project.github.io/lolbas/Binaries/WorkFolders/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 314
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Signed Proxy Execution via MS Work Folders

Work Folders is a role service for file servers running Windows Server that provides a consistent way for users to access their work files from their PCs and devices. This allows users to store work files and access them from anywhere. When called, Work Folders will automatically execute any Portable Executable (PE) named control.exe as an argument before accessing the synced share.
Using Work Folders to execute a masqueraded control.exe could allow an adversary to bypass application controls and increase privileges.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
  - Examine the location of the WorkFolders.exe binary to determine if it was copied to the location of the control.exe binary. It resides in the System32 directory by default.
- Trace the activity related to the control.exe binary to identify any continuing intrusion activity on the host.
- Review the control.exe binary executed with Work Folders to determine maliciousness such as additional host activity or network traffic.
- Determine if control.exe was synced to sync share, indicating potential lateral movement.
- Review how control.exe was originally delivered on the host, such as emailed, downloaded from the web, or written to
  disk from a separate binary.


### False positive analysis

- Windows Work Folders are used legitimately by end users and administrators for file sharing and syncing but not in the instance where a suspicious control.exe is passed as an argument.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Review the Work Folders synced share to determine if the control.exe was shared and if so remove it.
- If no lateral movement was identified during investigation, take the affected host offline if possible and remove the control.exe binary as well as any additional artifacts identified during investigation.
- Review integrating Windows Information Protection (WIP) to enforce data protection by encrypting the data on PCs using Work Folders.
- Confirm with the user whether this was expected or not, and reset their password.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : "control.exe" and process.parent.name : "WorkFolders.exe" and
  not process.executable : (
    "?:\\Windows\\System32\\control.exe",
    "?:\\Windows\\SysWOW64\\control.exe",

    /* Crowdstrike specific condition as it uses NT Object paths */
    "\\Device\\HarddiskVolume*\\Windows\\System32\\control.exe",
    "\\Device\\HarddiskVolume*\\Windows\\SysWOW64\\control.exe"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)