﻿---
title: Potential Evasion via Windows Filtering Platform
description: Identifies multiple Windows Filtering Platform block events and where the process name is related to an endpoint security software. Adversaries may add...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_windows_filtering_platform
products:
  - Elastic Security
---

# Potential Evasion via Windows Filtering Platform
Identifies multiple Windows Filtering Platform block events and where the process name is related to an endpoint
security software. Adversaries may add malicious WFP rules to prevent Endpoint security from sending telemetry.
**Rule type**: eql
**Rule indices**:
- logs-system.security*
- logs-windows.forwarded*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/dsnezhkov/shutter/tree/main](https://github.com/dsnezhkov/shutter/tree/main)](https://github.com/dsnezhkov/shutter/tree/main)
- [[https://github.com/netero1010/EDRSilencer/tree/main](https://github.com/netero1010/EDRSilencer/tree/main)](https://github.com/netero1010/EDRSilencer/tree/main)
- [[https://www.mdsec.co.uk/2023/09/nighthawk-0-2-6-three-wise-monkeys/](https://www.mdsec.co.uk/2023/09/nighthawk-0-2-6-three-wise-monkeys/)](https://www.mdsec.co.uk/2023/09/nighthawk-0-2-6-three-wise-monkeys/)
- [[https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5157](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5157)](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5157)
- [[https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5152](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5152)](https://learn.microsoft.com/en-us/windows/security/threat-protection/auditing/event-5152)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'Filtering Platform Connection' logging policy must be configured for (Success, Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Object Access >
Filtering Platform Connection (Success,Failure)
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Evasion via Windows Filtering Platform

The Windows Filtering Platform (WFP) is a set of API and system services that provide a platform for network filtering and packet processing. Adversaries may exploit WFP by creating malicious rules to block endpoint security processes, hindering their ability to send telemetry data. The detection rule identifies patterns of blocked network events linked to security software processes, signaling potential evasion tactics.

### Possible investigation steps

- Review the specific network events that triggered the alert, focusing on the event.action values "windows-firewall-packet-block" and "windows-firewall-packet-drop" to understand which processes were blocked.
- Identify the process names involved in the alert from the process.name field and verify if they are related to known endpoint security software, as listed in the query.
- Check the winlog.computer_name field to determine which systems are affected and assess if multiple systems are involved, indicating a broader issue.
- Investigate the recent changes to the Windows Filtering Platform rules on the affected systems to identify any unauthorized or suspicious modifications.
- Correlate the blocked events with any recent security incidents or alerts to determine if there is a pattern or ongoing attack.
- Consult system logs and security software logs on the affected systems for additional context or anomalies around the time of the alert.
- Engage with the system or network administrators to verify if any legitimate changes were made to the WFP rules that could explain the blocked events.


### False positive analysis

- Security software updates or installations can trigger multiple block events as they modify network configurations. Users should monitor for these events during known update windows and consider excluding them from alerts.
- Legitimate network troubleshooting or diagnostic tools may temporarily block network traffic as part of their operation. Identify these tools and create exceptions for their processes to prevent false alerts.
- Custom security configurations or policies in enterprise environments might intentionally block certain network activities. Review and document these configurations to differentiate between expected behavior and potential threats.
- Temporary network disruptions or misconfigurations can cause legitimate security processes to be blocked. Regularly audit network settings and ensure they align with security policies to minimize these occurrences.
- Scheduled maintenance or testing of security systems might result in blocked events. Coordinate with IT teams to whitelist these activities during planned maintenance periods.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further malicious activity and data exfiltration.
- Terminate any suspicious processes identified in the alert, particularly those related to endpoint security software, to restore normal security operations.
- Review and remove any unauthorized or suspicious Windows Filtering Platform rules that may have been added to block security processes.
- Conduct a thorough scan of the affected system using a trusted antivirus or endpoint detection and response (EDR) tool to identify and remove any malware or persistent threats.
- Restore any affected security software to its default configuration and ensure it is fully operational and updated.
- Monitor network traffic and system logs for any signs of continued evasion tactics or re-infection attempts.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
sequence by winlog.computer_name with maxspan=1m
 [network where host.os.type == "windows" and
  event.action : ("windows-firewall-packet-block", "windows-firewall-packet-drop") and
  process.name : (
        "bdagent.exe", "bdreinit.exe", "pdscan.exe", "pdiface.exe", "BDSubWiz.exe", "ProductAgentService.exe",
        "ProductAgentUI.exe", "WatchDog.exe", "CarbonBlackClientSetup.exe", "TrGUI.exe", "TracCAPI.exe", "cpmsi_tool.exe",
        "trac.exe", "vna_install64.exe", "vna_utils.exe", "TracSrvWrapper.exe", "vsmon.exe", "p95tray.exe",
        "CybereasonRansomFreeServiceHost.exe", "CrAmTray.exe", "minionhost.exe", "CybereasonSensor.exe", "CylanceUI.exe",
        "CylanceProtectSetup.exe", "cylancesvc.exe", "cyupdate.exe", "elastic-agent.exe", "elastic-endpoint.exe",
        "egui.exe", "minodlogin.exe", "emu-rep.exe", "emu_install.exe", "emu-cci.exe", "emu-gui.exe", "emu-uninstall.exe",
        "ndep.exe", "spike.exe", "ecls.exe", "ecmd.exe", "ecomserver.exe", "eeclnt.exe", "eh64.exe", "EHttpSrv.exe",
        "xagt.exe", "collectoragent.exe", "FSAEConfig.exe", "uninstalldcagent.exe", "rmon.exe", "fccomint.exe",
        "fclanguageselector.exe", "fortifw.exe", "fcreg.exe", "fortitray.exe", "fcappdb.exe", "fcwizard.exe", "submitv.exe",
        "av_task.exe", "fortiwf.exe", "fortiwadbd.exe", "fcauth.exe", "fcdblog.exe", "fcmgr.exe", "fortiwad.exe",
        "fortiproxy.exe", "fortiscand.exe", "fortivpnst.exe", "ipsec.exe", "fcwscd7.exe", "fcasc.exe", "fchelper.exe",
        "forticlient.exe","fcwsc.exe", "FortiClient.exe", "fmon.exe", "FSSOMA.exe", "FCVbltScan.exe", "FortiESNAC.exe",
        "EPCUserAvatar.exe", "FortiAvatar.exe", "FortiClient_Diagnostic_Tool.exe", "FortiSSLVPNdaemon.exe", "avp.exe",
        "FCConfig.exe", "avpsus.exe", "klnagent.exe", "klnsacwsrv.exe", "kl_platf.exe", "stpass.exe", "klnagwds.exe",
        "mbae.exe", "mbae64.exe", "mbae-svc.exe", "mbae-uninstaller.exe", "mbaeLoader32.exe", "mbaeloader64.exe",
        "mbam-dor.exe", "mbamgui.exe", "mbamservice.exe", "mbamtrayctrl.exe", "mbampt.exe", "mbamscheduler.exe",
        "Coreinst.exe", "mbae-setup.exe", "mcupdate.exe", "ProtectedModuleHost.exe", "ESConfigTool.exe", "FWInstCheck.exe",
        "FwWindowsFirewallHandler.exe", "mfeesp.exe", "mfefw.exe", "mfeProvisionModeUtility.exe", "mfetp.exe", "avpui.exe",
        "WscAVExe.exe", "mcshield.exe", "McChHost.exe", "mfewc.exe", "mfewch.exe", "mfewcui.exe", "fwinfo.exe",
        "mfecanary.exe", "mfefire.exe", "mfehidin.exe", "mfemms.exe", "mfevtps.exe", "mmsinfo.exe", "vtpinfo.exe",
        "MarSetup.exe", "mctray.exe", "masvc.exe", "macmnsvc.exe", "McAPExe.exe", "McPvTray.exe", "mcods.exe",
        "mcuicnt.exe", "mcuihost.exe", "xtray.exe", "McpService.exe", "epefprtrainer.exe", "mfeffcoreservice.exe",
        "MfeEpeSvc.exe", "qualysagent.exe", "QualysProxy.exe", "QualysAgentUI.exe", "SVRTgui.exe", "SVRTcli.exe",
        "SVRTcli.exe", "SVRTgui.exe", "SCTCleanupService.exe", "SVRTservice.exe", "native.exe", "SCTBootTasks.exe",
        "ALMon.exe", "SAA.exe", "SUMService.exe", "ssp.exe", "SCFService.exe", "SCFManager.exe", "spa.exe", "cabarc.exe",
        "sargui.exe", "sntpservice.exe", "McsClient.exe", "McsAgent.exe", "McsHeartbeat.exe", "SAVAdminService.exe",
        "sav32cli.exe", "ForceUpdateAlongSideSGN.exe", "SAVCleanupService.exe", "SavMain.exe", "SavProgress.exe",
        "SavProxy.exe", "SavService.exe", "swc_service.exe", "swi_di.exe", "swi_service.exe", "swi_filter.exe",
        "ALUpdate.exe", "SophosUpdate.exe", "ALsvc.exe", "SophosAlert.exe", "osCheck.exe", "N360Downloader.exe",
        "InstWrap.exe", "symbos.exe", "nss.exe", "symcorpui.exe", "isPwdSvc.exe", "ccsvchst.exe", "ntrmv.exe",
        "pccntmon.exe", "AosUImanager.exe", "NTRTScan.exe", "TMAS_OL.exe", "TMAS_OLImp.exe", "TMAS_OLSentry.exe",
        "ufnavi.exe", "Clnrbin.exe", "vizorhtmldialog.exe", "pwmConsole.exe", "PwmSvc.exe", "coreServiceShell.exe",
        "ds_agent.exe", "SfCtlCom.exe", "MBAMHelper.exe", "cb.exe", "smc.exe", "tda.exe", "xagtnotif.exe", "ekrn.exe",
        "dsa.exe", "Notifier.exe", "rphcp.exe", "lc_sensor.exe", "CSFalconService.exe", "CSFalconController.exe",
        "SenseSampleUploader.exe", "windefend.exe", "MSASCui.exe", "MSASCuiL.exe", "msmpeng.exe", "msmpsvc.exe",
        "MsSense.exe", "esensor.exe", "sentinelone.exe", "tmccsf.exe", "csfalconcontainer.exe", "sensecncproxy.exe",
        "splunk.exe", "sysmon.exe", "sysmon64.exe", "taniumclient.exe"
    )] with runs=5
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify System Firewall
- Id: T1562.004
- Reference URL: [[https://attack.mitre.org/techniques/T1562/004/](https://attack.mitre.org/techniques/T1562/004/)](https://attack.mitre.org/techniques/T1562/004/)