﻿---
title: Unusual Network Connection via RunDLL32
description: Identifies unusual instances of rundll32.exe making outbound network connections. This may indicate adversarial Command and Control activity. Rule type:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_network_connection_via_rundll32
products:
  - Elastic Security
---

# Unusual Network Connection via RunDLL32
Identifies unusual instances of rundll32.exe making outbound network connections. This may indicate adversarial Command
and Control activity.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.process-*
- logs-endpoint.events.network-*
- logs-windows.sysmon_operational-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)](https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml)
- [[https://redcanary.com/threat-detection-report/techniques/rundll32/](https://redcanary.com/threat-detection-report/techniques/rundll32/)](https://redcanary.com/threat-detection-report/techniques/rundll32/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Command and Control
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne

**Version**: 213
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Unusual Network Connection via RunDLL32

RunDLL32 is a built-in Windows utility and also a vital component used by the operating system itself. The functionality provided by RunDLL32 to execute Dynamic Link Libraries (DLLs) is widely abused by attackers, because it makes it hard to differentiate malicious activity from normal operations.
This rule looks for external network connections established using RunDLL32 when the utility is being executed with no arguments, which can potentially indicate command and control activity.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate the target host that RunDLL32 is communicating with.
  - Check if the domain is newly registered or unexpected.
- Check the reputation of the domain or IP address.
- Identify the target computer and its role in the IT environment.
- Assess whether this behavior is prevalent in the environment by looking for similar occurrences across hosts.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Review the privileges assigned to the user to ensure that the least privilege principle is being followed.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
sequence by host.id, process.entity_id with maxspan=1m
  [process where host.os.type == "windows" and event.type == "start" and process.name : "rundll32.exe" and
  (
    process.args_count == 1 and

    /* Excludes bug where a missing closing quote sets args_count to 1 despite extra args */
    not process.command_line regex~ """\".*\.exe[^\"].*"""
  )]
  [network where host.os.type == "windows" and process.name : "rundll32.exe" and
   not cidrmatch(destination.ip, "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24",
       "192.0.0.0/29", "192.0.0.8/32", "192.0.0.9/32", "192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32",
       "192.0.2.0/24", "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", "224.0.0.0/4",
       "100.64.0.0/10", "192.175.48.0/24","198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "240.0.0.0/4", "::1",
       "FE80::/10", "FF00::/8")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)
- Sub Technique:
  - Name: Rundll32
- Id: T1218.011
- Reference URL: [[https://attack.mitre.org/techniques/T1218/011/](https://attack.mitre.org/techniques/T1218/011/)](https://attack.mitre.org/techniques/T1218/011/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)
- Sub Technique:
  - Name: Web Protocols
- Id: T1071.001
- Reference URL: [[https://attack.mitre.org/techniques/T1071/001/](https://attack.mitre.org/techniques/T1071/001/)](https://attack.mitre.org/techniques/T1071/001/)