﻿---
title: Unsigned DLL Side-Loading from a Suspicious Folder
description: Identifies a Windows trusted program running from locations often abused by adversaries to masquerade as a trusted program and loading a recently dropped...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unsigned_dll_loaded_from_suspdir
products:
  - Elastic Security
---

# Unsigned DLL Side-Loading from a Suspicious Folder
Identifies a Windows trusted program running from locations often abused by adversaries to masquerade as a trusted
program and loading a recently dropped DLL. This behavior may indicate an attempt to evade defenses via side-loading a
malicious DLL within the memory space of a signed processes.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.library-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/Hunting-for-Suspicious-Windows-Libraries-for-Execution-and-Evasion](https://www.elastic.co/security-labs/Hunting-for-Suspicious-Windows-Libraries-for-Execution-and-Evasion)](https://www.elastic.co/security-labs/Hunting-for-Suspicious-Windows-Libraries-for-Execution-and-Evasion)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 14
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unsigned DLL Side-Loading from a Suspicious Folder

DLL side-loading exploits the trust of signed executables to load malicious DLLs, often from suspicious directories. Adversaries use this to bypass security measures by placing unsigned DLLs in locations mimicking legitimate paths. The detection rule identifies this by checking for trusted programs loading recently modified, unsigned DLLs from atypical directories, signaling potential evasion tactics.

### Possible investigation steps

- Review the process code signature to confirm the legitimacy of the trusted program that loaded the DLL. Check if the process is expected to run from the identified directory.
- Examine the DLL's path and creation or modification time to determine if it aligns with typical user or system activity. Investigate why the DLL was recently modified or created.
- Analyze the DLL's code signature status to understand why it is unsigned or has an error status. This can help identify if the DLL is potentially malicious.
- Investigate the parent process and any associated child processes to understand the context of the DLL loading event. This can provide insights into how the DLL was introduced.
- Check for any recent changes or anomalies in the system or user activity logs around the time the DLL was created or modified to identify potential indicators of compromise.
- Correlate the alert with other security events or alerts in the environment to determine if this is part of a broader attack or isolated incident.


### False positive analysis

- Legitimate software updates or installations may temporarily load unsigned DLLs from atypical directories. Users can create exceptions for known update processes by verifying the source and ensuring the process is part of a legitimate update.
- Custom or in-house applications might load unsigned DLLs from non-standard directories. Users should verify the application's behavior and, if deemed safe, exclude these specific paths or processes from the rule.
- Development environments often involve testing unsigned DLLs in various directories. Developers can exclude these environments by specifying the directories or processes involved in the development workflow.
- Some third-party security or system management tools may use unsigned DLLs for legitimate purposes. Users should confirm the tool's legitimacy and add exceptions for these tools to prevent false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat and to contain any malicious activity.
- Terminate the process associated with the unsigned DLL to stop any ongoing malicious operations.
- Quarantine the suspicious DLL file and any related files for further analysis to understand the scope and nature of the threat.
- Conduct a thorough scan of the affected system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious files or remnants.
- Review and restore any altered system configurations or settings to their original state to ensure system integrity.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if the threat has impacted other systems.
- Implement additional monitoring and logging on the affected system and network to detect any recurrence or similar threats in the future.


## Rule Query

```eql
library where host.os.type == "windows" and

 process.code_signature.trusted == true and

 (dll.Ext.relative_file_creation_time <= 500 or dll.Ext.relative_file_name_modify_time <= 500) and

  not dll.code_signature.status : ("trusted", "errorExpired", "errorCode_endpoint*", "errorChaining") and

      /* Suspicious Paths */
      dll.path : ("?:\\PerfLogs\\*.dll",
                  "?:\\Users\\*\\Pictures\\*.dll",
                  "?:\\Users\\*\\Music\\*.dll",
                  "?:\\Users\\Public\\*.dll",
                  "?:\\Users\\*\\Documents\\*.dll",
				  "?:\\Users\\*\\Downloads\\*.dll",
                  "?:\\Windows\\Tasks\\*.dll",
                  "?:\\Windows\\System32\\Tasks\\*.dll",
                  "?:\\Intel\\*.dll",
                  "?:\\AMD\\Temp\\*.dll",
                  "?:\\Windows\\AppReadiness\\*.dll",
                  "?:\\Windows\\ServiceState\\*.dll",
                  "?:\\Windows\\security\\*.dll",
		  "?:\\Windows\\System\\*.dll",
                  "?:\\Windows\\IdentityCRL\\*.dll",
                  "?:\\Windows\\Branding\\*.dll",
                  "?:\\Windows\\csc\\*.dll",
                  "?:\\Windows\\DigitalLocker\\*.dll",
                  "?:\\Windows\\en-US\\*.dll",
                  "?:\\Windows\\wlansvc\\*.dll",
                  "?:\\Windows\\Prefetch\\*.dll",
                  "?:\\Windows\\Fonts\\*.dll",
                  "?:\\Windows\\diagnostics\\*.dll",
                  "?:\\Windows\\TAPI\\*.dll",
                  "?:\\Windows\\INF\\*.dll",
                  "?:\\windows\\tracing\\*.dll",
                  "?:\\windows\\IME\\*.dll",
                  "?:\\Windows\\Performance\\*.dll",
                  "?:\\windows\\intel\\*.dll",
                  "?:\\windows\\ms\\*.dll",
                  "?:\\Windows\\dot3svc\\*.dll",
                  "?:\\Windows\\ServiceProfiles\\*.dll",
                  "?:\\Windows\\panther\\*.dll",
                  "?:\\Windows\\RemotePackages\\*.dll",
                  "?:\\Windows\\OCR\\*.dll",
                  "?:\\Windows\\appcompat\\*.dll",
                  "?:\\Windows\\apppatch\\*.dll",
                  "?:\\Windows\\addins\\*.dll",
                  "?:\\Windows\\Setup\\*.dll",
                  "?:\\Windows\\Help\\*.dll",
                  "?:\\Windows\\SKB\\*.dll",
                  "?:\\Windows\\Vss\\*.dll",
                  "?:\\Windows\\Web\\*.dll",
                  "?:\\Windows\\servicing\\*.dll",
                  "?:\\Windows\\CbsTemp\\*.dll",
                  "?:\\Windows\\Logs\\*.dll",
                  "?:\\Windows\\WaaS\\*.dll",
                  "?:\\Windows\\twain_32\\*.dll",
                  "?:\\Windows\\ShellExperiences\\*.dll",
                  "?:\\Windows\\ShellComponents\\*.dll",
                  "?:\\Windows\\PLA\\*.dll",
                  "?:\\Windows\\Migration\\*.dll",
                  "?:\\Windows\\debug\\*.dll",
                  "?:\\Windows\\Cursors\\*.dll",
                  "?:\\Windows\\Containers\\*.dll",
                  "?:\\Windows\\Boot\\*.dll",
                  "?:\\Windows\\bcastdvr\\*.dll",
                  "?:\\Windows\\TextInput\\*.dll",
                  "?:\\Windows\\schemas\\*.dll",
                  "?:\\Windows\\SchCache\\*.dll",
                  "?:\\Windows\\Resources\\*.dll",
                  "?:\\Windows\\rescache\\*.dll",
                  "?:\\Windows\\Provisioning\\*.dll",
                  "?:\\Windows\\PrintDialog\\*.dll",
                  "?:\\Windows\\PolicyDefinitions\\*.dll",
                  "?:\\Windows\\media\\*.dll",
                  "?:\\Windows\\Globalization\\*.dll",
                  "?:\\Windows\\L2Schemas\\*.dll",
                  "?:\\Windows\\LiveKernelReports\\*.dll",
                  "?:\\Windows\\ModemLogs\\*.dll",
                  "?:\\Windows\\ImmersiveControlPanel\\*.dll",
                  "?:\\$Recycle.Bin\\*.dll") and

	 /* DLL loaded from the process.executable current directory */
	 (endswith~(substring(dll.path, 0, length(dll.path) - (length(dll.name) + 1)), substring(process.executable, 0, length(process.executable) - (length(process.name) + 1))) or dll.name : "chrome_elf.dll")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)