﻿---
title: File Creation Time Changed
description: Identifies modification of a file creation time. Adversaries may modify file time attributes to blend malicious content with existing files. Timestomping...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_timestomp_sysmon
products:
  - Elastic Security
---

# File Creation Time Changed
Identifies modification of a file creation time. Adversaries may modify file time attributes to blend malicious content
with existing files. Timestomping is a technique that modifies the timestamps of a file often to mimic files that are in
trusted directories.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-windows.sysmon_operational-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Sysmon
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File Creation Time Changed

File creation timestamps are crucial for tracking file history and integrity. Adversaries may alter these timestamps, a tactic known as timestomping, to disguise malicious files as benign. This detection rule leverages Sysmon logs to identify suspicious changes in file creation times, excluding trusted processes and file types, thus highlighting potential evasion attempts by attackers.

### Possible investigation steps

- Review the Sysmon logs to confirm the event code 2, which indicates a file creation time change, and verify the associated process and file details.
- Identify the process executable path that triggered the alert and determine if it is outside the list of trusted paths specified in the query.
- Check the file extension and name to ensure they are not part of the excluded types such as "temp", "tmp", or "LOG".
- Investigate the user account associated with the event to determine if it is a non-system account, as the query excludes "SYSTEM", "Local Service", and "Network Service".
- Correlate the file creation time change event with other security events or logs to identify any related suspicious activities or patterns.
- Assess the file's location and context to determine if it is in a sensitive or unusual directory that could indicate malicious intent.
- If necessary, perform a deeper forensic analysis on the file and process to identify any potential malicious behavior or indicators of compromise.


### False positive analysis

- Trusted software updates or installations may alter file creation times. Exclude known update processes like msiexec.exe from detection to reduce noise.
- System maintenance tasks, such as disk cleanup, can modify timestamps. Exclude cleanmgr.exe to prevent these benign changes from triggering alerts.
- User-initiated actions in trusted applications like Chrome or Firefox might change file creation times. Exclude these applications to avoid unnecessary alerts.
- Temporary files created by legitimate processes may have altered timestamps. Exclude file extensions like temp and tmp to minimize false positives.
- System accounts such as SYSTEM or Local Service may perform legitimate file operations. Exclude these user names to focus on suspicious activities.


### Response and remediation

- Isolate the affected system from the network to prevent further malicious activity and lateral movement by the adversary.
- Conduct a thorough review of the file in question to determine if it is malicious. Use a combination of antivirus scans and manual analysis to assess the file's behavior and origin.
- If the file is confirmed to be malicious, remove it from the system and any other locations it may have been copied to. Ensure that all associated processes are terminated.
- Restore any affected files from a known good backup to ensure data integrity and continuity.
- Review and update endpoint protection settings to ensure that similar threats are detected and blocked in the future. This may include adjusting Sysmon configurations to enhance logging and detection capabilities.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems have been compromised.
- Document the incident, including all actions taken, to improve future response efforts and update threat intelligence databases with any new indicators of compromise (IOCs) identified.


## Rule Query

```eql
file where host.os.type == "windows" and
  event.provider == "Microsoft-Windows-Sysmon" and
  /* File creation time change */
  event.code == "2" and
  not process.executable :
           ("?:\\Program Files\\*",
            "?:\\Program Files (x86)\\*",
            "?:\\Windows\\system32\\cleanmgr.exe",
            "?:\\Windows\\system32\\msiexec.exe",
            "?:\\Windows\\syswow64\\msiexec.exe",
            "?:\\Windows\\system32\\svchost.exe",
            "?:\\WINDOWS\\system32\\backgroundTaskHost.exe",
            "?:\\Users\\*\\AppData\\Local\\Google\\Chrome\\Application\\chrome.exe",
            "?:\\Users\\*\\AppData\\Local\\Mozilla Firefox\\firefox.exe",
            "?:\\Users\\*\\AppData\\Local\\slack\\app-*\\slack.exe",
            "?:\\Users\\*\\AppData\\Local\\GitHubDesktop\\app-*\\GitHubDesktop.exe",
            "?:\\Users\\*\\AppData\\Local\\Microsoft\\Teams\\current\\Teams.exe",
            "?:\\Users\\*\\AppData\\Local\\Microsoft\\OneDrive\\OneDrive.exe") and
  not file.extension : ("temp", "tmp", "~tmp", "xml", "newcfg") and not user.name : ("SYSTEM", "Local Service", "Network Service") and
  not file.name : ("LOG", "temp-index", "license.rtf", "iconcache_*.db")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indicator Removal
- Id: T1070
- Reference URL: [[https://attack.mitre.org/techniques/T1070/](https://attack.mitre.org/techniques/T1070/)](https://attack.mitre.org/techniques/T1070/)
- Sub Technique:
  - Name: Timestomp
- Id: T1070.006
- Reference URL: [[https://attack.mitre.org/techniques/T1070/006/](https://attack.mitre.org/techniques/T1070/006/)](https://attack.mitre.org/techniques/T1070/006/)