﻿---
title: Suspicious Managed Code Hosting Process
description: Identifies a suspicious managed code hosting process which could indicate code injection or other form of suspicious code execution. Rule type: eql Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_managedcode_host_process
products:
  - Elastic Security
---

# Suspicious Managed Code Hosting Process
Identifies a suspicious managed code hosting process which could indicate code injection or other form of suspicious
code execution.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- endgame-*
- logs-crowdstrike.fdr*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [http://web.archive.org/web/20230329154538/[https://blog.menasec.net/2019/07/interesting-difr-traces-of-net-clr.html](https://blog.menasec.net/2019/07/interesting-difr-traces-of-net-clr.html)](http://web.archive.org/web/20230329154538/https://blog.menasec.net/2019/07/interesting-difr-traces-of-net-clr.html)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 312
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Managed Code Hosting Process

Managed code hosting processes like wscript.exe, cscript.exe, and others are integral to executing scripts and managing code in Windows environments. Adversaries exploit these processes for code injection or executing malicious scripts, often evading detection. The detection rule identifies anomalies by monitoring specific process logs, flagging high-risk activities that deviate from normal operations, thus alerting analysts to potential threats.

### Possible investigation steps

- Review the process logs for the specific file names flagged in the alert, such as wscript.exe.log or cscript.exe.log, to identify any unusual or unauthorized script executions.
- Correlate the suspicious process activity with user account activity to determine if the actions were performed by a legitimate user or potentially compromised account.
- Examine the parent process of the flagged managed code hosting process to identify if it was spawned by a legitimate application or a known malicious process.
- Check for any recent changes or modifications to the scripts or executables associated with the flagged process to identify potential tampering or unauthorized updates.
- Investigate network connections initiated by the suspicious process to detect any communication with known malicious IP addresses or domains.
- Utilize threat intelligence sources to cross-reference any identified indicators of compromise (IOCs) such as file hashes or IP addresses associated with the suspicious process.


### False positive analysis

- Legitimate administrative scripts may trigger alerts when executed by IT personnel using wscript.exe or cscript.exe. To manage this, create exceptions for known scripts and trusted user accounts.
- Automated system maintenance tasks using mshta.exe or wmic.exe can be flagged as suspicious. Identify and whitelist these tasks if they are part of regular system operations.
- Software updates or installations might use svchost.exe or dllhost.exe, leading to false positives. Monitor and document these activities, then exclude them from alerts if they are verified as safe.
- Custom applications that rely on cmstp.exe or regsvr32.exe for legitimate purposes can be mistaken for threats. Validate these applications and add them to an exception list to prevent unnecessary alerts.
- Regularly review and update the exception list to ensure it reflects current legitimate activities, minimizing the risk of overlooking genuine threats.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further spread or communication with potential command and control servers.
- Terminate the suspicious process identified in the alert, such as wscript.exe, cscript.exe, or any other flagged process, to stop any ongoing malicious activity.
- Conduct a thorough scan of the affected system using updated antivirus and anti-malware tools to identify and remove any additional malicious files or scripts.
- Review and restore any system or application configurations that may have been altered by the malicious process to ensure system integrity.
- Collect and preserve relevant logs and forensic data from the affected system for further analysis and to aid in understanding the scope and impact of the incident.
- Notify the security operations center (SOC) or incident response team to escalate the incident for further investigation and to determine if additional systems are affected.
- Implement additional monitoring and detection rules to enhance visibility and prevent similar threats in the future, focusing on the specific processes and behaviors identified in the alert.


## Rule Query

```eql
file where host.os.type == "windows" and event.type != "deletion" and
  file.name : ("wscript.exe.log",
               "cscript.exe.log",
               "mshta.exe.log",
               "wmic.exe.log",
               "svchost.exe.log",
               "dllhost.exe.log",
               "cmstp.exe.log",
               "regsvr32.exe.log")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Process Injection
- Id: T1055
- Reference URL: [[https://attack.mitre.org/techniques/T1055/](https://attack.mitre.org/techniques/T1055/)](https://attack.mitre.org/techniques/T1055/)