﻿---
title: Potential Secure File Deletion via SDelete Utility
description: Detects file name patterns generated by the use of Sysinternals SDelete utility to securely delete a file via multiple file overwrite and rename operations...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sdelete_like_filename_rename
products:
  - Elastic Security
---

# Potential Secure File Deletion via SDelete Utility
Detects file name patterns generated by the use of Sysinternals SDelete utility to securely delete a file via multiple
file overwrite and rename operations.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-crowdstrike.fdr*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Impact
- Data Source: Elastic Endgame
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 312
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential Secure File Deletion via SDelete Utility

SDelete is a tool primarily used for securely deleting data from storage devices, making it unrecoverable. Microsoft develops it as part of the Sysinternals Suite. Although commonly used to delete data securely, attackers can abuse it to delete forensic indicators and remove files as a post-action to a destructive action such as ransomware or data theft to hinder recovery efforts.
This rule identifies file name patterns generated by the use of SDelete utility to securely delete a file via multiple file overwrite and rename operations.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Examine the command line and identify the files deleted, their importance and whether they could be the target of antiforensics activity.


### False positive analysis

- This is a dual-use tool, meaning its usage is not inherently malicious. Analysts can dismiss the alert if the administrator is aware of the activity, no other suspicious activity was identified, and there are justifications for the execution.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
  - Prioritize cases involving critical servers and users.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- If important data was encrypted, deleted, or modified, activate your data recovery plan.
  - Perform data recovery locally or restore the backups from replicated copies (cloud, other servers, etc.).
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Review the privileges assigned to the user to ensure that the least privilege principle is being followed.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
file where host.os.type == "windows" and event.type == "change" and file.name : "*AAA.AAA"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indicator Removal
- Id: T1070
- Reference URL: [[https://attack.mitre.org/techniques/T1070/](https://attack.mitre.org/techniques/T1070/)](https://attack.mitre.org/techniques/T1070/)
- Sub Technique:
  - Name: File Deletion
- Id: T1070.004
- Reference URL: [[https://attack.mitre.org/techniques/T1070/004/](https://attack.mitre.org/techniques/T1070/004/)](https://attack.mitre.org/techniques/T1070/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Destruction
- Id: T1485
- Reference URL: [[https://attack.mitre.org/techniques/T1485/](https://attack.mitre.org/techniques/T1485/)](https://attack.mitre.org/techniques/T1485/)