﻿---
title: Service DACL Modification via sc.exe
description: Identifies DACL modifications to deny access to a service, making it unstoppable, or hide it from system and users. Rule type: eql Rule indices: winlogbeat-*,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sc_sdset
products:
  - Elastic Security
---

# Service DACL Modification via sc.exe
Identifies DACL modifications to deny access to a service, making it unstoppable, or hide it from system and users.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.process-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-sentinel_one_cloud_funnel.*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://blogs.jpcert.or.jp/en/2024/07/mirrorface-attack-against-japanese-organisations.html](https://blogs.jpcert.or.jp/en/2024/07/mirrorface-attack-against-japanese-organisations.html)](https://blogs.jpcert.or.jp/en/2024/07/mirrorface-attack-against-japanese-organisations.html)
- [[https://github.com/SigmaHQ/sigma/blob/master/rules/windows/process_creation/proc_creation_win_sc_sdset_deny_service_access.yml](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/process_creation/proc_creation_win_sc_sdset_deny_service_access.yml)](https://github.com/SigmaHQ/sigma/blob/master/rules/windows/process_creation/proc_creation_win_sc_sdset_deny_service_access.yml)
- [[https://learn.microsoft.com/en-us/windows/win32/secauthz/sid-strings](https://learn.microsoft.com/en-us/windows/win32/secauthz/sid-strings)](https://learn.microsoft.com/en-us/windows/win32/secauthz/sid-strings)
- [[https://www.sans.org/blog/red-team-tactics-hiding-windows-services/](https://www.sans.org/blog/red-team-tactics-hiding-windows-services/)](https://www.sans.org/blog/red-team-tactics-hiding-windows-services/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Service DACL Modification via sc.exe

The `sc.exe` utility in Windows is used to manage services, including modifying their Discretionary Access Control Lists (DACLs). Adversaries may exploit this to alter service permissions, making them unmanageable or hidden. The detection rule identifies such modifications by monitoring for specific command patterns that indicate DACL changes, focusing on access denial to key user groups, thus flagging potential defense evasion attempts.

### Possible investigation steps

- Review the process execution details to confirm the presence of "sc.exe" with the "sdset" argument, indicating a potential DACL modification attempt.
- Examine the specific arguments used with "sc.exe" to identify which user groups (e.g., IU, SU, BA, SY, WD) were targeted for access denial.
- Check the process execution timeline to determine if this activity coincides with other suspicious behavior or unauthorized access attempts.
- Investigate the user account associated with the process execution to assess if it has the necessary privileges and if the activity aligns with their typical behavior.
- Correlate this event with other security alerts or logs from data sources like Elastic Endgame, Sysmon, or Microsoft Defender for Endpoint to identify potential patterns or related incidents.
- Assess the impact on the affected service by verifying its current state and functionality, ensuring it is not hidden or unmanageable.
- If necessary, consult with system administrators to understand the legitimate need for such modifications and confirm if the activity was authorized.


### False positive analysis

- Routine administrative tasks using sc.exe to modify service permissions may trigger the rule. Review the context of the command and verify if it aligns with standard IT maintenance activities.
- Automated scripts or software deployment tools that adjust service DACLs for legitimate configuration purposes can cause false positives. Identify these scripts and consider excluding their specific command patterns from the rule.
- Security software updates or patches that modify service permissions as part of their installation process might be flagged. Confirm the legitimacy of the update and exclude the associated process arguments if necessary.
- Custom applications that require specific service permissions for functionality may inadvertently match the detection criteria. Validate the application's behavior and create exceptions for its known safe operations.
- Regular audits or compliance checks that involve service DACL modifications could be misinterpreted as malicious. Document these activities and adjust the rule to ignore them when performed by authorized personnel.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or changes to service permissions.
- Terminate any suspicious processes related to sc.exe that are actively modifying service DACLs to stop ongoing malicious activity.
- Restore the original DACL settings for the affected services using a known good configuration or backup to ensure proper access control is reinstated.
- Conduct a thorough review of user accounts and permissions to identify and revoke any unauthorized access that may have been granted during the attack.
- Implement additional monitoring on the affected system and similar systems to detect any further attempts to modify service DACLs, using enhanced logging and alerting mechanisms.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if the attack is part of a larger campaign.
- Review and update endpoint protection policies to prevent similar threats in the future, ensuring that all systems are equipped with the latest security patches and configurations.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (process.name : "sc.exe" or ?process.pe.original_file_name : "sc.exe") and
  process.args : "sdset" and process.args : "*D;*" and
  process.args : ("*;IU*", "*;SU*", "*;BA*", "*;SY*", "*;WD*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)
- Sub Technique:
  - Name: Windows Service
- Id: T1543.003
- Reference URL: [[https://attack.mitre.org/techniques/T1543/003/](https://attack.mitre.org/techniques/T1543/003/)](https://attack.mitre.org/techniques/T1543/003/)