﻿---
title: Potential PowerShell Obfuscation via Reverse Keywords
description: Identifies PowerShell scripts that use reversed strings as a form of obfuscation. These methods are designed to evade static analysis and bypass security...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_reverse_keyword
products:
  - Elastic Security
---

# Potential PowerShell Obfuscation via Reverse Keywords
Identifies PowerShell scripts that use reversed strings as a form of obfuscation. These methods are designed to evade
static analysis and bypass security protections such as the Antimalware Scan Interface (AMSI).
**Rule type**: esql
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'PowerShell Script Block Logging' logging policy must be enabled.
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Administrative Templates >
Windows PowerShell >
Turn on PowerShell Script Block Logging (Enable)
```

Steps to implement the logging policy via registry:
```
reg add "hklm\SOFTWARE\Policies\Microsoft\Windows\PowerShell\ScriptBlockLogging" /v EnableScriptBlockLogging /t REG_DWORD /d 1
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential PowerShell Obfuscation via Reverse Keywords

PowerShell, a powerful scripting language in Windows environments, is often targeted by adversaries for obfuscation to bypass security measures like AMSI. Attackers reverse keywords in scripts to evade static analysis. The detection rule identifies such obfuscation by searching for reversed keywords, replacing them with a unique marker, and counting occurrences. This helps in flagging scripts with multiple obfuscated elements, indicating potential malicious activity.

### Possible investigation steps

- Review the `powershell.file.script_block_text` field to understand the context and content of the script that triggered the alert. Look for any suspicious or unexpected behavior in the script logic.
- Examine the `file.path` field to determine the location of the script on the system. This can provide insights into whether the script is part of a legitimate application or potentially malicious.
- Check the `powershell.file.script_block_id` and `powershell.sequence` fields to identify if the script is part of a larger sequence of commands. This can help in understanding the full scope of the script's execution.
- Investigate the `agent.id` field to identify the specific endpoint where the script was executed. This can help in correlating with other alerts or logs from the same machine.
- Assess the `count` field to determine the extent of obfuscation. A higher count may indicate a more heavily obfuscated script, suggesting a higher likelihood of malicious intent.


### False positive analysis

- Scripts with legitimate administrative functions may use reversed keywords for benign purposes, such as custom logging or debugging. Review the context of the script to determine if the usage is intentional and non-malicious.
- Automated scripts generated by legitimate software tools might include reversed keywords as part of their normal operation. Identify these tools and create exceptions for their known script patterns to prevent unnecessary alerts.
- Developers or IT personnel might use reversed keywords in test environments to simulate obfuscation techniques. Ensure these environments are well-documented and excluded from production monitoring to avoid false positives.
- PowerShell scripts used in educational or training settings may intentionally include obfuscation techniques for learning purposes. Exclude these scripts by identifying their unique characteristics or file paths.
- Regularly update the list of excluded scripts or patterns as new legitimate use cases are identified, ensuring the detection rule remains effective without generating excessive false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of potentially malicious scripts.
- Terminate any suspicious PowerShell processes identified by the alert to halt ongoing malicious activity.
- Conduct a thorough review of the script block text and associated files to understand the scope and intent of the obfuscation.
- Remove or quarantine any identified malicious scripts or files from the system to prevent re-execution.
- Restore affected systems from a known good backup if malicious activity has altered system integrity.
- Update endpoint protection and security tools to recognize and block similar obfuscation techniques in the future.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and monitoring of potential lateral movement or additional threats.


## Rule Query

```esql
from logs-windows.powershell_operational* metadata _id, _version, _index
| where event.code == "4104"

// Filter for scripts that contains these keywords using MATCH, boosts the query performance,
// match will ignore the | and look for the individual words
| where powershell.file.script_block_text : "rahc|metsys|stekcos|tcejboimw|ecalper|ecnerferpe|noitcennoc|nioj|eman|vne|gnirts|tcejbo-wen|_23niw|noisserpxe|ekovni|daolnwod"

// replace the patterns we are looking for with the 🔥 emoji to enable counting them
// The emoji is used because it's unlikely to appear in scripts and has a consistent character length of 1
| eval Esql.script_block_tmp = replace(
    powershell.file.script_block_text,
    """(?i)(rahc|metsys|stekcos|tcejboimw|ecalper|ecnerferpe|noitcennoc|nioj|eman\.|:vne$|gnirts|tcejbo-wen|_23niw|noisserpxe|ekovni|daolnwod)""",
    "🔥"
)

// count how many patterns were detected by calculating the number of 🔥 characters inserted
| eval Esql.script_block_pattern_count = length(Esql.script_block_tmp) - length(replace(Esql.script_block_tmp, "🔥", ""))

// keep the fields relevant to the query, although this is not needed as the alert is populated using _id
| keep
    Esql.script_block_pattern_count,
    Esql.script_block_tmp,
    powershell.file.*,
    file.path,
    powershell.sequence,
    powershell.total,
    _id,
    _version,
    _index,
    agent.id

// Filter for scripts that match the pattern at least twice
| where Esql.script_block_pattern_count >= 2
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)