﻿---
title: Potential PowerShell Obfuscation via Concatenated Dynamic Command Invocation
description: Identifies PowerShell scripts that use concatenated strings within dynamic command invocation (&() or .()) as a form of obfuscation. These methods are...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_concat_dynamic
products:
  - Elastic Security
---

# Potential PowerShell Obfuscation via Concatenated Dynamic Command Invocation
Identifies PowerShell scripts that use concatenated strings within dynamic command invocation (&() or .()) as a form of
obfuscation. These methods are designed to evade static analysis and bypass security protections such as the Antimalware
Scan Interface (AMSI).
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The 'PowerShell Script Block Logging' logging policy must be enabled.
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Administrative Templates >
Windows PowerShell >
Turn on PowerShell Script Block Logging (Enable)
```

Steps to implement the logging policy via registry:
```
reg add "hklm\SOFTWARE\Policies\Microsoft\Windows\PowerShell\ScriptBlockLogging" /v EnableScriptBlockLogging /t REG_DWORD /d 1
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential PowerShell Obfuscation via Concatenated Dynamic Command Invocation

PowerShell is a powerful scripting language used for task automation and configuration management in Windows environments. Adversaries exploit its capabilities by obfuscating commands to evade detection, often using concatenated strings in dynamic invocations. This detection rule identifies such obfuscation by analyzing script patterns, specifically looking for concatenated strings within dynamic command invocations, which are indicative of attempts to bypass security measures like AMSI. By counting these patterns, the rule effectively flags suspicious scripts, aiding in the identification of potential threats.

### Possible investigation steps

- Review the `powershell.file.script_block_text` field to understand the content and purpose of the script, focusing on the concatenated strings and dynamic command invocations.
- Check the `host.name` and `user.id` fields to identify the machine and user account associated with the execution of the suspicious script, which can help determine if the activity is expected or anomalous.
- Analyze the `file.path` field to locate the script's source or storage location, which may provide additional context or indicate if the script is part of a known application or process.
- Investigate the `powershell.file.script_block_id` and `powershell.sequence` fields to trace the execution sequence and correlate it with other related PowerShell activities, which might reveal a broader pattern of behavior.
- Assess the `agent.id` field to determine the specific endpoint agent involved, which can assist in further endpoint-specific investigations or actions.


### False positive analysis

- Scripts with legitimate concatenated strings for dynamic command execution may trigger the rule. Review the script context to determine if the concatenation serves a valid administrative purpose.
- Automated scripts from trusted sources that use concatenation for modularity or readability might be flagged. Consider adding these scripts to an allowlist if they are verified as safe.
- Development or testing environments where PowerShell scripts are frequently modified and tested could generate false positives. Implement exceptions for known development hosts or user accounts.
- Security tools or monitoring solutions that use PowerShell for legitimate operations may inadvertently match the pattern. Identify these tools and exclude their operations from the rule.
- Regularly review and update the exclusion list to ensure it reflects the current environment and does not inadvertently allow malicious activity.


### Response and remediation

- Isolate the affected host immediately to prevent further execution of potentially malicious scripts and limit lateral movement within the network.
- Terminate any suspicious PowerShell processes identified by the alert to halt the execution of obfuscated commands.
- Conduct a thorough review of the script block text and associated script block ID to understand the intent and potential impact of the obfuscated commands.
- Remove any unauthorized or malicious scripts from the affected system and ensure that all legitimate scripts are verified and signed.
- Restore the affected system from a known good backup if any malicious activity is confirmed, ensuring that all data integrity checks are performed.
- Escalate the incident to the security operations team for further analysis and to determine if additional systems have been compromised.
- Update endpoint protection and monitoring tools to enhance detection capabilities for similar obfuscation techniques, leveraging insights from the MITRE ATT&CK framework.


## Rule Query

```esql
from logs-windows.powershell_operational* metadata _id, _version, _index
| where event.code == "4104" and powershell.file.script_block_text like "*+*"

// replace the patterns we are looking for with the 🔥 emoji to enable counting them
// The emoji is used because it's unlikely to appear in scripts and has a consistent character length of 1
| eval Esql.script_block_tmp = replace(
    powershell.file.script_block_text,
    """[.&]\(\s*(['"][A-Za-z0-9.-]+['"]\s*\+\s*)+['"][A-Za-z0-9.-]+['"]\s*\)""",
    "🔥"
)

// count how many patterns were detected by calculating the number of 🔥 characters inserted
| eval Esql.script_block_pattern_count = length(Esql.script_block_tmp) - length(replace(Esql.script_block_tmp, "🔥", ""))

// keep the fields relevant to the query, although this is not needed as the alert is populated using _id
| keep
    Esql.script_block_pattern_count,
    Esql.script_block_tmp,
    powershell.file.*,
    file.path,
    powershell.sequence,
    powershell.total,
    _id,
    _version,
    _index,
    host.name,
    agent.id,
    user.id

// Filter for scripts that match the pattern at least once
| where Esql.script_block_pattern_count >= 1
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)