﻿---
title: Microsoft Windows Defender Tampering
description: Identifies when one or more features on Microsoft Defender are disabled. Adversaries may disable or tamper with Microsoft Defender features to evade detection...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_microsoft_defender_tampering
products:
  - Elastic Security
---

# Microsoft Windows Defender Tampering
Identifies when one or more features on Microsoft Defender are disabled. Adversaries may disable or tamper with
Microsoft Defender features to evade detection and conceal malicious behavior.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.registry-*
- logs-windows.sysmon_operational-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- endgame-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://thedfirreport.com/2021/10/18/icedid-to-xinglocker-ransomware-in-24-hours/](https://thedfirreport.com/2021/10/18/icedid-to-xinglocker-ransomware-in-24-hours/)](https://thedfirreport.com/2021/10/18/icedid-to-xinglocker-ransomware-in-24-hours/)
- [[https://www.tenforums.com/tutorials/32236-enable-disable-microsoft-defender-pua-protection-windows-10-a.html](https://www.tenforums.com/tutorials/32236-enable-disable-microsoft-defender-pua-protection-windows-10-a.html)](https://www.tenforums.com/tutorials/32236-enable-disable-microsoft-defender-pua-protection-windows-10-a.html)
- [[https://www.tenforums.com/tutorials/104025-turn-off-core-isolation-memory-integrity-windows-10-a.html](https://www.tenforums.com/tutorials/104025-turn-off-core-isolation-memory-integrity-windows-10-a.html)](https://www.tenforums.com/tutorials/104025-turn-off-core-isolation-memory-integrity-windows-10-a.html)
- [[https://www.tenforums.com/tutorials/105533-enable-disable-windows-defender-exploit-protection-settings.html](https://www.tenforums.com/tutorials/105533-enable-disable-windows-defender-exploit-protection-settings.html)](https://www.tenforums.com/tutorials/105533-enable-disable-windows-defender-exploit-protection-settings.html)
- [[https://www.tenforums.com/tutorials/123792-turn-off-tamper-protection-microsoft-defender-antivirus.html](https://www.tenforums.com/tutorials/123792-turn-off-tamper-protection-microsoft-defender-antivirus.html)](https://www.tenforums.com/tutorials/123792-turn-off-tamper-protection-microsoft-defender-antivirus.html)
- [[https://www.tenforums.com/tutorials/51514-turn-off-microsoft-defender-periodic-scanning-windows-10-a.html](https://www.tenforums.com/tutorials/51514-turn-off-microsoft-defender-periodic-scanning-windows-10-a.html)](https://www.tenforums.com/tutorials/51514-turn-off-microsoft-defender-periodic-scanning-windows-10-a.html)
- [[https://www.tenforums.com/tutorials/3569-turn-off-real-time-protection-microsoft-defender-antivirus.html](https://www.tenforums.com/tutorials/3569-turn-off-real-time-protection-microsoft-defender-antivirus.html)](https://www.tenforums.com/tutorials/3569-turn-off-real-time-protection-microsoft-defender-antivirus.html)
- [[https://www.tenforums.com/tutorials/99576-how-schedule-scan-microsoft-defender-antivirus-windows-10-a.html](https://www.tenforums.com/tutorials/99576-how-schedule-scan-microsoft-defender-antivirus-windows-10-a.html)](https://www.tenforums.com/tutorials/99576-how-schedule-scan-microsoft-defender-antivirus-windows-10-a.html)
- [[https://www.elastic.co/security-labs/invisible-miners-unveiling-ghostengine](https://www.elastic.co/security-labs/invisible-miners-unveiling-ghostengine)](https://www.elastic.co/security-labs/invisible-miners-unveiling-ghostengine)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Data Source: Elastic Endgame
- Data Source: Crowdstrike

**Version**: 317
**Rule authors**:
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Microsoft Windows Defender Tampering

Microsoft Windows Defender is an antivirus product built into Microsoft Windows, which makes it popular across multiple environments. Disabling it is a common step in threat actor playbooks.
This rule monitors the registry for modifications that disable Windows Defender features.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Validate the activity is not related to planned patches, updates, network administrator activity, or legitimate software installations.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Examine which features have been disabled, and check if this operation is done under change management and approved according to the organization's policy.


### False positive analysis

- This mechanism can be used legitimately. Analysts can dismiss the alert if the administrator is aware of the activity, the configuration is justified (for example, it is being used to deploy other security solutions or troubleshooting), and no other suspicious activity has been observed.


### Related rules

- Windows Defender Disabled via Registry Modification - 2ffa1f1e-b6db-47fa-994b-1512743847eb
- Disabling Windows Defender Security Settings via PowerShell - c8cccb06-faf2-4cd5-886e-2c9636cfcb87


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Take actions to restore the appropriate Windows Defender antivirus configurations.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Review the privileges assigned to the user to ensure that the least privilege principle is being followed.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
registry where host.os.type == "windows" and event.type == "change" and process.executable != null and
  (
    (
      registry.value : (
        "PUAProtection", "DisallowExploitProtectionOverride", "TamperProtection", "EnableControlledFolderAccess",
        "SpynetReporting", "SubmitSamplesConsent"
      ) and registry.data.strings : ("0", "0x00000000")
    ) or
    (
      registry.value : (
        "DisableAntiSpyware", "DisableRealtimeMonitoring", "DisableIntrusionPreventionSystem", "DisableScriptScanning",
        "DisableIOAVProtection", "DisableEnhancedNotifications", "DisableBlockAtFirstSeen", "DisableBehaviorMonitoring"
      ) and registry.data.strings : ("1", "0x00000001")
    )
  ) and
  not process.executable : (
    "?:\\Windows\\system32\\svchost.exe", 
    "?:\\Windows\\CCM\\CcmExec.exe", 
    "?:\\Windows\\System32\\DeviceEnroller.exe", 
    "?:\\Program Files (x86)\\Trend Micro\\Security Agent\\tmuninst.exe",
    "\\Device\\HarddiskVolume*\\Windows\\system32\\svchost.exe", 
    "\\Device\\HarddiskVolume*\\Windows\\CCM\\CcmExec.exe", 
    "\\Device\\HarddiskVolume*\\Windows\\System32\\DeviceEnroller.exe", 
    "\\Device\\HarddiskVolume*\\Program Files (x86)\\Trend Micro\\Security Agent\\tmuninst.exe"
  )

/*
    Full registry key paths omitted due to data source variations:
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\DisableAntiSpyware"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection\\DisableRealtimeMonitoring"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection\\DisableIntrusionPreventionSystem"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection\\DisableScriptScanning"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection\\DisableIOAVProtection"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Reporting\\DisableEnhancedNotifications"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\SpyNet\\DisableBlockAtFirstSeen"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection\\DisableBehaviorMonitoring"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\PUAProtection"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender Security Center\\App and Browser protection\\DisallowExploitProtectionOverride"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Features\\TamperProtection"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Windows Defender Exploit Guard\\Controlled Folder Access\\EnableControlledFolderAccess"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\SpyNet\\SpynetReporting"
    "HKLM\\SOFTWARE\\Policies\\Microsoft\\Windows Defender\\SpyNet\\SubmitSamplesConsent"
*/
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)