﻿---
title: Potential Masquerading as Svchost
description: Identifies attempts to masquerade as the Service Host process svchost.exe to evade detection and blend in with normal system activity. Rule type: esql...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_as_svchost
products:
  - Elastic Security
---

# Potential Masquerading as Svchost
Identifies attempts to masquerade as the Service Host process `svchost.exe` to evade detection and blend in with normal system activity.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 8m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Sysmon

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Masquerading as Svchost

svchost.exe is a legitimate Windows system process responsible for hosting multiple Windows services. Adversaries may attempt to masquerade as svchost.exe to evade detection and blend in with normal system activity. This is often achieved by renaming a malicious executable to svchost.exe, placing it outside of standard Windows directories or running it with unusual parent processes or command-line arguments.

### Possible investigation steps

- Review the process.executable and process.parent.executable fields to confirm the location and unexpected parents..
- Check the process.command_line field for unusual arguments. Legitimate svchost.exe instances typically use the -k parameter followed by a valid service group name.
- Investigate the process.code_signature field to determine if the binary is signed by Microsoft. Unsigned or invalid signatures are strong indicators of masquerading.
- Correlate the event with other telemetry from the same host to identify additional indicators such as file creation, network connections, or registry modifications related to the suspicious process.
- Review related file creation events to determine how and when the fake svchost.exe was introduced to the system (e.g. dropped by another malware component or downloaded from the network).


### False positive analysis

- Some legitimate third-party applications may use executables named svchost.exe within their own installation paths. Verify the vendor, file hash, and digital signature to determine legitimacy.
- In virtualized or sandboxed environments, custom service hosts may appear with similar naming conventions. Validate these against known baseline configurations.
- Ensure that system recovery or diagnostic tools using temporary binaries are not misidentified as malicious. Review event timing and system logs to confirm.
- Regularly maintain an inventory of known legitimate `svchost.exe` locations and hashes to minimize false positives across managed hosts.


### Response and remediation

- Isolate the affected host immediately to prevent lateral movement or further compromise.
- Terminate any suspicious svchost.exe processes executing from non-standard locations.
- Quarantine and remove the rogue binary after verification through hash reputation or sandbox analysis.
- Perform a full system scan to identify additional malicious files or persistence mechanisms associated with the masqueraded process.
- Review and reset any credentials used by the compromised process if credential theft or impersonation is suspected.
- Analyze recent network activity from the affected host for potential data exfiltration or commandand-control communication.
- Escalate the incident to the security operations or incident response team for deeper investigation and forensic analysis.
- Implement detections to monitor for future attempts of process masquerading, and update security baselines and EDR exclusions accordingly.


## Rule Query

```esql
FROM logs-endpoint.events.process-*, logs-windows.sysmon_operational-*, logs-system.security-*, logs-windows.*, winlogbeat-* metadata _id, _version, _index
| where event.category == "process" and event.type == "start" and
  match(process.name, "svchost.exe", { "fuzziness": 1, "max_expansions": 10 }) and
  not to_lower(process.executable) in ("c:\\windows\\syswow64\\svchost.exe", "c:\\windows\\system32\\svchost.exe") and
  not to_lower(process.executable) like """\\device\\harddiskvolume*\\windows\\system32\\svchost.exe""" and
  not to_lower(process.executable) like """\\device\\harddiskvolume*\\windows\\syswow64\\svchost.exe""" 
| keep event.dataset, host.name, host.id, user.id, user.name, process.executable, process.parent.executable, process.command_line, _id, _version, _index
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Match Legitimate Resource Name or Location
- Id: T1036.005
- Reference URL: [[https://attack.mitre.org/techniques/T1036/005/](https://attack.mitre.org/techniques/T1036/005/)](https://attack.mitre.org/techniques/T1036/005/)