﻿---
title: Encoded Executable Stored in the Registry
description: Identifies registry write modifications to hide an encoded portable executable. This could be indicative of adversary defense evasion by avoiding the...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_hide_encoded_executable_registry
products:
  - Elastic Security
---

# Encoded Executable Stored in the Registry
Identifies registry write modifications to hide an encoded portable executable. This could be indicative of adversary
defense evasion by avoiding the storing of malicious content directly on disk.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.registry-*
- endgame-*
- logs-windows.sysmon_operational-*
- logs-sentinel_one_cloud_funnel.*
- winlogbeat-*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 415
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Encoded Executable Stored in the Registry

Windows Registry is a hierarchical database storing low-level settings for the OS and applications. Adversaries exploit it to hide encoded executables, evading detection by avoiding direct disk storage. The detection rule identifies suspicious registry modifications, specifically targeting encoded patterns indicative of hidden executables, thus flagging potential defense evasion tactics.

### Possible investigation steps

- Review the registry path and key where the modification was detected to understand the context and potential impact on the system.
- Analyze the encoded data string "TVqQAAMAAAAEAAAA*" to determine if it corresponds to a known malicious executable or pattern.
- Check the modification timestamp to correlate with any other suspicious activities or events on the system around the same time.
- Investigate the process or user account responsible for the registry modification to assess if it is associated with legitimate activity or known threats.
- Cross-reference the alert with other data sources such as Sysmon, Microsoft Defender for Endpoint, or SentinelOne for additional context or corroborating evidence of malicious behavior.
- Evaluate the system's network activity and connections during the time of the registry modification to identify any potential command and control communications or data exfiltration attempts.


### False positive analysis

- Legitimate software installations or updates may write encoded executables to the registry as part of their normal operation. Users can create exceptions for known software by identifying their specific registry paths and excluding them from the detection rule.
- Security tools and system management software might store encoded data in the registry for legitimate purposes. Review the registry paths and data associated with these tools and exclude them if they are verified as non-threatening.
- Custom scripts or enterprise applications developed in-house may use encoded executables in the registry for deployment or configuration purposes. Work with development teams to identify these scripts and add exceptions for their registry modifications.
- Regularly review and update the list of exceptions to ensure that only verified and necessary exclusions are maintained, minimizing the risk of overlooking potential threats.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat.
- Use endpoint detection and response (EDR) tools to terminate any suspicious processes associated with the encoded executable.
- Remove the malicious registry entry by using a trusted registry editor or automated script to ensure the encoded executable is no longer stored in the registry.
- Conduct a full system scan using updated antivirus and anti-malware tools to identify and remove any additional threats or remnants of the attack.
- Restore the system from a known good backup if the integrity of the system is compromised and cannot be assured through cleaning.
- Monitor the system and network for any signs of re-infection or similar registry modifications, adjusting detection rules if necessary to enhance future threat identification.
- Escalate the incident to the security operations center (SOC) or relevant cybersecurity team for further analysis and to determine if additional systems are affected.


## Rule Query

```eql
registry where host.os.type == "windows" and
/* update here with encoding combinations */
 registry.data.strings : "TVqQAAMAAAAEAAAA*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Registry
- Id: T1112
- Reference URL: [[https://attack.mitre.org/techniques/T1112/](https://attack.mitre.org/techniques/T1112/)](https://attack.mitre.org/techniques/T1112/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)