﻿---
title: Suspicious Microsoft Antimalware Service Execution
description: Identifies suspicious execution of the Microsoft Antimalware Service Executable (MsMpEng.exe) from non-standard paths or renamed instances. This may indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_windefend_unusual_path
products:
  - Elastic Security
---

# Suspicious Microsoft Antimalware Service Execution
Identifies suspicious execution of the Microsoft Antimalware Service Executable (MsMpEng.exe) from non-standard paths or
renamed instances. This may indicate an attempt to evade defenses through DLL side-loading or by masquerading as the
antimalware process.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.process-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://news.sophos.com/en-us/2021/07/04/independence-day-revil-uses-supply-chain-exploit-to-attack-hundreds-of-businesses/](https://news.sophos.com/en-us/2021/07/04/independence-day-revil-uses-supply-chain-exploit-to-attack-hundreds-of-businesses/)](https://news.sophos.com/en-us/2021/07/04/independence-day-revil-uses-supply-chain-exploit-to-attack-hundreds-of-businesses/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Tactic: Execution
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 216
**Rule authors**:
- Elastic
- Dennis Perto

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Microsoft Antimalware Service Execution

The Microsoft Antimalware Service Executable, a core component of Windows Defender, is crucial for real-time protection against malware. Adversaries exploit its trust by renaming it or executing it from non-standard paths to load malicious DLLs, bypassing security measures. The detection rule identifies such anomalies by monitoring process names and paths, flagging deviations from expected behavior to uncover potential threats.

### Possible investigation steps

- Review the process details to confirm if the process name is MsMpEng.exe but is executing from a non-standard path. Check the process.executable field to identify the exact path and verify if it deviates from the expected directories.
- Investigate the parent process of the suspicious MsMpEng.exe instance to determine how it was initiated. This can provide insights into whether the process was started by a legitimate application or a potentially malicious one.
- Examine the system for any recent file modifications or creations in the directory where the suspicious MsMpEng.exe is located. This can help identify if a malicious DLL was recently placed in the same directory.
- Check for any network connections or communications initiated by the suspicious MsMpEng.exe process. This can help determine if the process is attempting to communicate with external servers, which may indicate malicious activity.
- Look for any other processes or activities on the host that may indicate compromise, such as unusual user account activity or other processes running from unexpected locations. This can help assess the broader impact of the potential threat.


### False positive analysis

- Legitimate software updates or installations may temporarily rename or relocate the Microsoft Antimalware Service Executable. Users should verify if any software updates or installations occurred around the time of the alert and consider excluding these paths if they are known and trusted.
- Custom security or IT management tools might execute the executable from non-standard paths for monitoring or testing purposes. Confirm with IT or security teams if such tools are in use and add these paths to the exclusion list if they are verified as safe.
- Virtualization or sandbox environments may replicate the executable in different locations for testing or analysis. Check if the environment is part of a controlled setup and exclude these paths if they are part of legitimate operations.
- Backup or recovery processes might involve copying the executable to alternate locations. Ensure these processes are legitimate and consider excluding these paths if they are part of routine operations.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further spread of the potential threat.
- Terminate any suspicious processes identified by the detection rule, specifically those involving MsMpEng.exe running from non-standard paths.
- Conduct a thorough scan of the affected system using an updated antivirus or endpoint detection and response (EDR) tool to identify and remove any malicious DLLs or other malware.
- Review and restore any altered or deleted system files from a known good backup to ensure system integrity.
- Investigate the source of the DLL side-loading attempt to determine if it was part of a broader attack campaign, and gather forensic evidence for further analysis.
- Escalate the incident to the security operations center (SOC) or incident response team for a deeper investigation and to assess the need for further containment measures.
- Implement additional monitoring and alerting for similar anomalies in process execution paths to enhance detection capabilities and prevent recurrence.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(
  (process.pe.original_file_name == "MsMpEng.exe" and not process.name : "MsMpEng.exe") or
  (
    process.name : "MsMpEng.exe" and
    not process.executable : (
            "?:\\ProgramData\\Microsoft\\Windows Defender\\*.exe",
            "?:\\Program Files\\Windows Defender\\*.exe",
            "?:\\Program Files (x86)\\Windows Defender\\*.exe",
            "?:\\Program Files\\Microsoft Security Client\\*.exe",
            "?:\\Program Files (x86)\\Microsoft Security Client\\*.exe",

            /* Crowdstrike specific exclusion as it uses NT Object paths */
            "\\Device\\HarddiskVolume*\\ProgramData\\Microsoft\\Windows Defender\\*.exe",
            "\\Device\\HarddiskVolume*\\Program Files\\Windows Defender\\*.exe",
            "\\Device\\HarddiskVolume*\\Program Files (x86)\\Windows Defender\\*.exe",
            "\\Device\\HarddiskVolume*\\Program Files\\Microsoft Security Client\\*.exe",
            "\\Device\\HarddiskVolume*\\Program Files (x86)\\Microsoft Security Client\\*.exe"
    )
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)