﻿---
title: Potential DLL Side-Loading via Trusted Microsoft Programs
description: Identifies an instance of a Windows trusted program that is known to be vulnerable to DLL Search Order Hijacking starting after being renamed or from...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_suspicious_explorer_winword
products:
  - Elastic Security
---

# Potential DLL Side-Loading via Trusted Microsoft Programs
Identifies an instance of a Windows trusted program that is known to be vulnerable to DLL Search Order Hijacking
starting after being renamed or from a non-standard path. This is uncommon behavior and may indicate an attempt to evade
defenses via side loading a malicious DLL within the memory space of one of those processes.
**Rule type**: eql
**Rule indices**:
- winlogbeat-*
- logs-endpoint.events.process-*
- logs-windows.sysmon_operational-*
- endgame-*
- logs-m365_defender.event-*
- logs-crowdstrike.fdr*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Microsoft Defender for Endpoint
- Resources: Investigation Guide
- Data Source: Crowdstrike
- Data Source: SentinelOne

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential DLL Side-Loading via Trusted Microsoft Programs

DLL side-loading exploits the DLL search order to load malicious code into trusted Microsoft programs, which are often whitelisted by security tools. Adversaries rename or relocate these programs to execute unauthorized DLLs, evading detection. The detection rule identifies unusual execution paths or renamed instances of these programs, signaling potential misuse and enabling timely threat response.

### Possible investigation steps

- Review the process details to confirm the original file name and the path from which the process was executed. Check if the process.pe.original_file_name matches any of the specified trusted programs like "WinWord.exe", "EXPLORER.EXE", "w3wp.exe", or "DISM.EXE".
- Investigate the process execution path to determine if it deviates from the standard paths listed in the query, such as "?:\Windows\explorer.exe" or "?:\Program Files\Microsoft Office\root\Office*\WINWORD.EXE".
- Examine the process creation history and parent process to identify any unusual or suspicious parent-child relationships that might indicate malicious activity.
- Check for any recent file modifications or creations in the directory from which the process was executed, which could suggest the presence of a malicious DLL.
- Correlate the event with other security logs or alerts from data sources like Elastic Endgame, Elastic Defend, Sysmon, or Microsoft Defender for Endpoint to gather additional context and identify potential patterns of malicious behavior.
- Assess the risk and impact of the event by considering the risk score and severity level provided, and determine if immediate containment or further investigation is necessary.


### False positive analysis

- Legitimate software updates or installations may temporarily execute trusted Microsoft programs from non-standard paths. Users can create exceptions for known update processes to prevent false alerts.
- Custom enterprise applications might use renamed instances of trusted Microsoft programs for legitimate purposes. Identify and whitelist these specific applications to avoid unnecessary alerts.
- Virtual environments or sandboxed applications may execute trusted programs from unusual paths as part of their normal operation. Review and exclude these environments if they are known and trusted.
- Security or IT administrative tools might mimic trusted Microsoft programs for monitoring or management tasks. Verify these tools and add them to an exception list if they are part of standard operations.
- Development or testing environments often involve renamed or relocated executables for debugging purposes. Ensure these environments are recognized and excluded from the detection rule to reduce false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat and unauthorized access.
- Terminate the suspicious process identified by the detection rule to stop any ongoing malicious activity.
- Conduct a forensic analysis of the affected system to identify any malicious DLLs or additional compromised files, and remove them.
- Restore the affected system from a known good backup to ensure all malicious changes are reverted.
- Update and patch all software on the affected system, focusing on the trusted Microsoft programs identified in the alert, to mitigate vulnerabilities exploited by DLL side-loading.
- Monitor the network for any signs of lateral movement or additional compromised systems, using the indicators of compromise identified during the investigation.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if additional systems or data have been affected.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (
    process.name : ("WinWord.exe", "EXPLORER.EXE", "w3wp.exe", "DISM.EXE") or
    ?process.pe.original_file_name : ("WinWord.exe", "EXPLORER.EXE", "w3wp.exe", "DISM.EXE")
  ) and
  not process.executable : (
          "\\\\?\\Volume{????????-????-????-????-????????????}\\Windows\\System32\\inetsrv\\w3wp.exe",
          "?:\\PROGRA~?\\MICROS~?\\Office??\\winword.exe",
          "?:\\Program Files\\Microsoft Office\\*\\winword.exe",
          "?:\\Program Files\\Microsoft Office ??\\*\\winword.exe",
          "?:\\Program Files\\WindowsApps\\Microsoft.Office.Desktop.*\\Office??\\winword.exe",
          "?:\\Program Files (x86)\\Microsoft Office\\*\\winword.exe",
          "?:\\Program Files (x86)\\Windows Kits\\*Assessment and Deployment Kit\\Deployment Tools\\amd64\\DISM\\dism.exe",
          "?:\\Windows\\explorer.exe",
          "?:\\Windows\\System32\\Dism.exe",
          "?:\\Windows\\System32\\inetsrv\\w3wp.exe",
          "?:\\Windows\\SysWOW64\\Dism.exe",
          "?:\\Windows\\SysWOW64\\explorer.exe",
          "?:\\Windows\\SysWOW64\\inetsrv\\w3wp.exe"
  ) and
  /* Crowdstrike specific exclusion as it uses NT Object paths */
  not
  (
    data_stream.dataset == "crowdstrike.fdr" and
    process.executable : (
        "\\Device\\HarddiskVolume*\\Program Files\\Microsoft Office\\*\\winword.exe",
        "\\Device\\HarddiskVolume*\\Program Files\\Microsoft Office ??\\*\\winword.exe",
        "\\Device\\HarddiskVolume*\\Program Files\\WindowsApps\\Microsoft.Office.Desktop.*\\Office??\\winword.exe",
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\Microsoft Office\\*\\winword.exe",
        "\\Device\\HarddiskVolume*\\Program Files (x86)\\Windows Kits\\10\\Assessment and Deployment Kit\\Deployment Tools\\amd64\\DISM\\dism.exe",
        "\\Device\\HarddiskVolume*\\Windows\\explorer.exe",
        "\\Device\\HarddiskVolume*\\Windows\\System32\\Dism.exe",
        "\\Device\\HarddiskVolume*\\Windows\\System32\\inetsrv\\w3wp.exe",
        "\\Device\\HarddiskVolume*\\Windows\\SysWOW64\\Dism.exe",
        "\\Device\\HarddiskVolume*\\Windows\\SysWOW64\\explorer.exe",
        "\\Device\\HarddiskVolume*\\Windows\\SysWOW64\\inetsrv\\w3wp.exe"
    )
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)
- Sub Technique:
  - Name: DLL
- Id: T1574.001
- Reference URL: [[https://attack.mitre.org/techniques/T1574/001/](https://attack.mitre.org/techniques/T1574/001/)](https://attack.mitre.org/techniques/T1574/001/)