﻿---
title: Suspicious .NET Code Compilation
description: Identifies executions of .NET compilers with suspicious parent processes, which can indicate an attacker's attempt to compile code after delivery in order...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_dotnet_compiler_parent_process
products:
  - Elastic Security
---

# Suspicious .NET Code Compilation
Identifies executions of .NET compilers with suspicious parent processes, which can indicate an attacker's attempt to
compile code after delivery in order to bypass security mechanisms.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 316
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious .NET Code Compilation

.NET compilers like `csc.exe` and `vbc.exe` are integral to compiling C# and VB.NET code, respectively, in Windows environments. Adversaries exploit these compilers by executing them with unusual parent processes, such as scripting engines or system utilities, to compile malicious code stealthily. The detection rule identifies such anomalies by monitoring compiler executions initiated by suspicious parent processes, signaling potential evasion or execution tactics.

### Possible investigation steps

- Review the process tree to understand the relationship between the suspicious parent process (e.g., wscript.exe, mshta.exe) and the .NET compiler process (csc.exe or vbc.exe) to determine if the execution flow is typical or anomalous.
- Examine the command-line arguments used by the .NET compiler process to identify any potentially malicious code or scripts being compiled.
- Check the user account associated with the process execution to determine if it aligns with expected behavior or if it indicates potential compromise or misuse.
- Investigate the source and integrity of the parent process executable to ensure it has not been tampered with or replaced by a malicious version.
- Correlate the event with other security alerts or logs from the same host or user to identify any patterns or additional indicators of compromise.
- Analyze network activity from the host around the time of the alert to detect any suspicious outbound connections that may indicate data exfiltration or command-and-control communication.


### False positive analysis

- Legitimate software development activities may trigger this rule if developers use scripting engines or system utilities to automate the compilation of .NET code. To manage this, identify and whitelist known development environments or scripts that frequently compile code using these methods.
- System administrators might use scripts or automation tools that invoke .NET compilers for maintenance tasks. Review and document these processes, then create exceptions for recognized administrative scripts to prevent unnecessary alerts.
- Some enterprise applications may use .NET compilers as part of their normal operation, especially if they dynamically generate or compile code. Investigate these applications and exclude their processes from the rule if they are verified as non-threatening.
- Security tools or monitoring solutions might simulate suspicious behavior for testing purposes, which could trigger this rule. Coordinate with your security team to identify such tools and exclude their activities from detection.
- In environments where custom scripts are frequently used for deployment or configuration, ensure these scripts are reviewed and, if safe, added to an exclusion list to reduce false positives.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further execution or spread of potentially malicious code.
- Terminate any suspicious processes identified, such as `csc.exe` or `vbc.exe`, that are running with unusual parent processes.
- Conduct a thorough scan of the isolated system using updated antivirus and endpoint detection tools to identify and remove any malicious files or remnants.
- Review and analyze the execution logs to determine the source and scope of the threat, focusing on the parent processes like `wscript.exe` or `mshta.exe` that initiated the compiler execution.
- Restore the system from a known good backup if malicious activity is confirmed and cannot be fully remediated through cleaning.
- Implement application whitelisting to prevent unauthorized execution of compilers and scripting engines by non-standard parent processes.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the need for broader organizational response measures.


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  process.name : ("csc.exe", "vbc.exe") and
  process.parent.name : ("wscript.exe", "mshta.exe", "cscript.exe", "wmic.exe", "svchost.exe", "rundll32.exe", "cmstp.exe", "regsvr32.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Sub Technique:
  - Name: Compile After Delivery
- Id: T1027.004
- Reference URL: [[https://attack.mitre.org/techniques/T1027/004/](https://attack.mitre.org/techniques/T1027/004/)](https://attack.mitre.org/techniques/T1027/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Visual Basic
- Id: T1059.005
- Reference URL: [[https://attack.mitre.org/techniques/T1059/005/](https://attack.mitre.org/techniques/T1059/005/)](https://attack.mitre.org/techniques/T1059/005/)