﻿---
title: Disable Windows Event and Security Logs Using Built-in Tools
description: Identifies attempts to disable EventLog via the logman Windows utility, PowerShell, or auditpol. This is often done by attackers in an attempt to evade...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disabling_windows_logs
products:
  - Elastic Security
---

# Disable Windows Event and Security Logs Using Built-in Tools
Identifies attempts to disable EventLog via the logman Windows utility, PowerShell, or auditpol. This is often done by
attackers in an attempt to evade detection on a system.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/logman](https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/logman)](https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/logman)
- [[https://medium.com/palantir/tampering-with-windows-event-tracing-background-offense-and-defense-4be7ac62ac63](https://medium.com/palantir/tampering-with-windows-event-tracing-background-offense-and-defense-4be7ac62ac63)](https://medium.com/palantir/tampering-with-windows-event-tracing-background-offense-and-defense-4be7ac62ac63)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 318
**Rule authors**:
- Elastic
- Ivan Ninichuck
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Disable Windows Event and Security Logs Using Built-in Tools

Windows event logs are a fundamental data source for security monitoring, forensics, and incident response. Adversaries can tamper, clear, and delete this data to break SIEM detections, cover their tracks, and slow down incident response.
This rule looks for the usage of different utilities to disable the EventLog service or specific event logs.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
  - Verify if any other anti-forensics behaviors were observed.
- Investigate the event logs prior to the action for suspicious behaviors that an attacker may be trying to cover up.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Re-enable affected logging components, services, and security monitoring.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
(
  (
    (process.name:"logman.exe" or ?process.pe.original_file_name == "Logman.exe") and
    process.args : "EventLog-*" and process.args : ("stop", "delete")
  ) or
  (
    (
      process.name : ("pwsh.exe", "powershell.exe", "powershell_ise.exe") or
      ?process.pe.original_file_name in ("PowerShell.EXE", "pwsh.dll", "powershell_ise.EXE")
    ) and
	  process.args : "Set-Service" and process.args: "EventLog" and process.args : "Disabled"
  )  or
  (
    (process.name:"auditpol.exe" or ?process.pe.original_file_name == "AUDITPOL.EXE") and process.args : "/success:disable"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indicator Removal
- Id: T1070
- Reference URL: [[https://attack.mitre.org/techniques/T1070/](https://attack.mitre.org/techniques/T1070/)](https://attack.mitre.org/techniques/T1070/)
- Sub Technique:
  - Name: Clear Windows Event Logs
- Id: T1070.001
- Reference URL: [[https://attack.mitre.org/techniques/T1070/001/](https://attack.mitre.org/techniques/T1070/001/)](https://attack.mitre.org/techniques/T1070/001/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable Windows Event Logging
- Id: T1562.002
- Reference URL: [[https://attack.mitre.org/techniques/T1562/002/](https://attack.mitre.org/techniques/T1562/002/)](https://attack.mitre.org/techniques/T1562/002/)
- Sub Technique:
  - Name: Indicator Blocking
- Id: T1562.006
- Reference URL: [[https://attack.mitre.org/techniques/T1562/006/](https://attack.mitre.org/techniques/T1562/006/)](https://attack.mitre.org/techniques/T1562/006/)