﻿---
title: Code Signing Policy Modification Through Built-in tools
description: Identifies attempts to disable/modify the code signing policy through system native utilities. Code signing provides authenticity on a program, and grants...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_code_signing_policy_modification_builtin_tools
products:
  - Elastic Security
---

# Code Signing Policy Modification Through Built-in tools
Identifies attempts to disable/modify the code signing policy through system native utilities. Code signing provides
authenticity on a program, and grants the user with the ability to check whether the program has been tampered with. By
allowing the execution of unsigned or self-signed code, threat actors can craft and execute malicious code.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Resources: Investigation Guide
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike

**Version**: 214
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Code Signing Policy Modification Through Built-in tools

Windows Driver Signature Enforcement (DSE) is a security feature introduced by Microsoft to enforce that only signed drivers can be loaded and executed into the kernel (ring 0). This feature was introduced to prevent attackers from loading their malicious drivers on targets. If the driver has an invalid signature, the system will not allow it to be loaded.
This protection is essential for maintaining the security of the system. However, attackers or even administrators can disable this feature and load untrusted drivers, as this can put the system at risk. Therefore, it is important to keep this feature enabled and only load drivers from trusted sources to ensure the integrity and security of the system.
This rule identifies commands that can disable the Driver Signature Enforcement feature.> **Note**:
This investigation guide uses the [Osquery Markdown Plugin](https://www.elastic.co/guide/en/security/current/invest-guide-run-osquery.html) introduced in Elastic Stack version 8.5.0. Older Elastic Stack versions will display unrendered Markdown in this guide.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Use Osquery and endpoint driver events (`event.category = "driver"`) to investigate if suspicious drivers were loaded into the system after the command was executed.
  - $osquery_0
- $osquery_1
- Identify the driver's `Device Name` and `Service Name`.
- Check for alerts from the rules specified in the `Related Rules` section.


### False positive analysis

- This activity should not happen legitimately. The security team should address any potential benign true positive (B-TP), as this configuration can put the user and the domain at risk.


### Related Rules

- First Time Seen Driver Loaded - df0fd41e-5590-4965-ad5e-cd079ec22fa9
- Untrusted Driver Loaded - d8ab1ec1-feeb-48b9-89e7-c12e189448aa
- Code Signing Policy Modification Through Registry - da7733b1-fe08-487e-b536-0a04c6d8b0cd


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further post-compromise behavior.
- Disable and uninstall all suspicious drivers found in the system. This can be done via Device Manager. (Note that this step may require you to boot the system into Safe Mode.)
- Remove the related services and registry keys found in the system. Note that the service will probably not stop if the driver is still installed.
  - This can be done via PowerShell `Remove-Service` cmdlet.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Remove and block malicious artifacts identified during triage.
- Ensure that the Driver Signature Enforcement is enabled on the system.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and
  (process.name: "bcdedit.exe" or ?process.pe.original_file_name == "bcdedit.exe") and process.args: ("-set", "/set") and 
  process.args: ("TESTSIGNING", "nointegritychecks", "loadoptions", "DISABLE_INTEGRITY_CHECKS")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Subvert Trust Controls
- Id: T1553
- Reference URL: [[https://attack.mitre.org/techniques/T1553/](https://attack.mitre.org/techniques/T1553/)](https://attack.mitre.org/techniques/T1553/)
- Sub Technique:
  - Name: Code Signing Policy Modification
- Id: T1553.006
- Reference URL: [[https://attack.mitre.org/techniques/T1553/006/](https://attack.mitre.org/techniques/T1553/006/)](https://attack.mitre.org/techniques/T1553/006/)