﻿---
title: Windows Event Logs Cleared
description: Identifies attempts to clear Windows event log stores. This is often done by attackers in an attempt to evade detection or destroy forensic evidence on...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_clearing_windows_security_logs
products:
  - Elastic Security
---

# Windows Event Logs Cleared
Identifies attempts to clear Windows event log stores. This is often done by attackers in an attempt to evade detection
or destroy forensic evidence on a system.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-system.security*
- logs-system.system*
- logs-windows.forwarded*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide
- Data Source: Windows Security Event Logs
- Data Source: Windows System Event Logs

**Version**: 215
**Rule authors**:
- Elastic
- Anabella Cristaldi

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Windows Event Logs Cleared

Windows event logs are a fundamental data source for security monitoring, forensics, and incident response. Adversaries can tamper, clear, and delete this data to break SIEM detections, cover their tracks, and slow down incident response.
This rule looks for the occurrence of clear actions on the `security` event log.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
  - Verify if any other anti-forensics behaviors were observed.
- Investigate the event logs prior to the action for suspicious behaviors that an attacker may be trying to cover up.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
  - This activity is potentially done after the adversary achieves its objectives on the host. Ensure that previous actions, if any, are investigated accordingly with their response playbooks.
- Isolate the involved host to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
host.os.type:windows and event.action:("audit-log-cleared" or "Log clear") and
  not winlog.provider_name:"AD FS Auditing"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indicator Removal
- Id: T1070
- Reference URL: [[https://attack.mitre.org/techniques/T1070/](https://attack.mitre.org/techniques/T1070/)](https://attack.mitre.org/techniques/T1070/)
- Sub Technique:
  - Name: Clear Windows Event Logs
- Id: T1070.001
- Reference URL: [[https://attack.mitre.org/techniques/T1070/001/](https://attack.mitre.org/techniques/T1070/001/)](https://attack.mitre.org/techniques/T1070/001/)