﻿---
title: Potential Antimalware Scan Interface Bypass via PowerShell
description: Detects PowerShell scripts that references Antimalware Scan Interface (AMSI) bypass classes, methods, or known bypass strings. Attackers attempt AMSI...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_amsi_bypass_powershell
products:
  - Elastic Security
---

# Potential Antimalware Scan Interface Bypass via PowerShell
Detects PowerShell scripts that references Antimalware Scan Interface (AMSI) bypass classes, methods, or known bypass
strings. Attackers attempt AMSI bypass to disable scanning and run malicious PowerShell content undetected.
**Rule type**: query
**Rule indices**:
- winlogbeat-*
- logs-windows.powershell*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell](https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell)](https://github.com/S3cur3Th1sSh1t/Amsi-Bypass-Powershell)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: PowerShell Logs
- Resources: Investigation Guide

**Version**: 116
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

PowerShell Script Block Logging must be enabled to generate the events used by this rule (e.g., 4104).
Setup instructions: [https://ela.st/powershell-logging-setup](https://ela.st/powershell-logging-setup)

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Antimalware Scan Interface Bypass via PowerShell

This rule detects PowerShell script block content that references Antimalware Scan Interface (AMSI) bypass techniques. This behavior is commonly used to impair PowerShell content scanning and is frequently a precursor to additional PowerShell activity that would otherwise be inspected.

#### Key alert fields to review

- `user.name`, `user.domain`, `user.id`: Account execution context for correlation, prioritization, and scoping.
- `host.name`, `host.id`: Host execution context for correlation, prioritization, and scoping.
- `powershell.file.script_block_text`: Script block content that matched the detection logic.
- `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`: Script block metadata to pivot to other fragments or reconstruct full script content when split across multiple events.
- `file.path`, `file.directory`, `file.name`: File-origin context when the script block is sourced from an on-disk file.
- `powershell.file.script_block_length`: Script block length (size) context.


#### Possible investigation steps

- Validate the intent of the script block:
  - Review `powershell.file.script_block_text` and identify which AMSI-related indicators are present (for example, `System.Management.Automation.AmsiUtils`, `amsiInitFailed`, `amsiContext`, `amsiSession`, `AmsiInitialize`, `amsi.dll`).
- Identify bypass techniques suggested by the script content, such as reflection-based field modification (for example, `Assembly.GetType(` and `.SetValue(`) or in-memory modification patterns (for example, `AllocHGlobal`).
- Note explicit bypass helper names in the script text (for example, `Invoke-AmsiBypass`, `Bypass.AMSI`, `FindAmsiFun`, `unloadobfuscated`, `unloadsilent`) and any obfuscation (mixed casing, character-code string construction, normalization, or heavy use of `-replace`).
- Treat this alert as an AMSI bypass attempt; success is not typically confirmed from the matching script block alone, so prioritize follow-on activity review.
- Reconstruct the complete script when content is split across multiple events:
  - Pivot on `powershell.file.script_block_id` and collect all related fragments.
- Order fragments by `powershell.sequence` and confirm the expected count with `powershell.total`.
- Re-review the reconstructed text for additional behaviors beyond the bypass attempt (for example, retrieving additional content, decoding staged data, or invoking suspicious functions).
- Determine the likely source of the script content:
  - Review `file.path` and `file.name` when present to identify an on-disk script source.
- Assess whether the path and filename align with established administrative tooling for the user/host, or whether it appears in an unexpected or transient location (for example, user profile, Temp, Downloads, or other user-writable locations).
- If `file.path` is not present, treat the source as unknown and prioritize correlation with other telemetry based on `host.name` and `@timestamp`.
- Establish the execution scope and operator context:
  - Review `user.name`, `user.domain`, and `user.id` to understand which account generated the script block content and whether it is expected to run PowerShell on `host.name`.
- Review `host.name` and `host.id` to determine whether the activity is isolated to a single endpoint or recurring across multiple systems.
- Identify repeated alerts involving the same `user.id` and/or `host.id` in a short period, which may indicate iterative testing of bypass variants or repeated execution of the same script.
- Hunt for related PowerShell activity on the same endpoint and account:
  - Search for additional script blocks on the same `host.id` around `@timestamp` to identify activity immediately before and after the bypass attempt.
- Use distinctive strings from `powershell.file.script_block_text` (function names, variable names, or unique encodings) to identify reuse by the same `user.id` or across other hosts.
- Extract any observable indicators embedded in the script text (for example, domains, IPs, URLs, or file paths) and use them to expand scoping searches.
- Correlate with adjacent telemetry using `host.name`, `user.name`, and the alert time window (if available in your environment):
  - Process execution telemetry to identify how PowerShell was launched and the initiating parent process (interactive use vs. another application or automation).
- Network telemetry for outbound connections and DNS activity that align with any remote retrieval or command-and-control behavior implied by the script content.
- File and registry telemetry for artifacts consistent with payload staging or persistence created shortly after the bypass attempt.
- Authentication telemetry to identify unusual or new logon activity for the implicated user on the affected host near the alert time.


### False positive analysis

- Training material or code snippets may be executed verbatim in a console during learning exercises. Confirm the context in `powershell.file.script_block_text` and whether additional suspicious behaviors appear in nearby script blocks from the same user and host.


### Response and remediation

- If the activity is confirmed or strongly suspected to be malicious:
  - Contain the affected host to prevent further execution and lateral movement.
- Preserve evidence from the alert: `powershell.file.script_block_text`, `powershell.file.script_block_id`, `powershell.sequence`, `powershell.total`, `host.name`, `host.id`, `user.name`, `user.domain`, `user.id`, and any associated `file.path`/`file.name`.
- If `file.path` is present, collect the referenced script from disk (if still available) and identify where else it exists in the environment.
- Scope for additional impacted systems by searching for the same bypass strings and distinctive patterns across other hosts and users.
- Investigate and remediate follow-on actions identified in the reconstructed script and adjacent script blocks (for example, retrieval of additional code, credential access attempts, or persistence).
- Reset credentials for involved accounts when warranted and review for further suspicious activity tied to `user.id` across the environment.
- Reduce the likelihood of recurrence:
  - Ensure PowerShell logging is appropriately enabled and centrally collected to support reconstruction and scoping.
- Apply least privilege and limit PowerShell usage to approved roles and systems where feasible.
- Review monitoring coverage for repeated AMSI bypass attempts and related PowerShell activity on the same host or by the same user.


## Rule Query

```kuery
event.category:"process" and host.os.type:windows and
  (
    powershell.file.script_block_text : (
      "System.Management.Automation.AmsiUtils" or
			amsiInitFailed or 
			"Invoke-AmsiBypass" or 
			"Bypass.AMSI" or 
			"amsi.dll" or 
			AntimalwareProvider  or 
			amsiSession or 
			amsiContext or
			AmsiInitialize or 
			unloadobfuscated or 
			unloadsilent or 
			AmsiX64 or 
			AmsiX32 or 
			FindAmsiFun or
		    "AllocHGlobal((9076" or
		    "[cHAr](65)+[cHaR]([byTe]0x6d)+[ChaR]([ByTe]0x73)+[CHaR]([BYte]0x69"
    ) or
    powershell.file.script_block_text:("[Ref].Assembly.GetType(('System.Management.Automation" and ".SetValue(") or
    powershell.file.script_block_text:("::AllocHGlobal((" and ".SetValue(" and "-replace" and ".NoRMALiZe(")
  ) and
  not powershell.file.script_block_text : (
    "sentinelbreakpoints" and "Set-PSBreakpoint"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: PowerShell
- Id: T1059.001
- Reference URL: [[https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)](https://attack.mitre.org/techniques/T1059/001/)